      SUBROUTINE  checkit
c
c...Make Sure That Zone Is Sorted In RA
c
c	NOTE:  Rings near (but not at) the pole will fail the 2-way
c	merge algorithm.  If we sense that the ring is not sorted,
c	sort and save it.
c
      INCLUDE
     *         'ugap012.inc'
      INTEGER
     *         i, n, nlb, j, m
      CHARACTER*64
     *         lb
      CHARACTER*3
     *         cz
c
 9001 FORMAT (' Zone ', i3, ' Is OK.  N=', i12)
 9002 FORMAT (i3.3)
 9003 FORMAT (2i10)
 9004 FORMAT (' Zone ', i3, ' Is Out Of Order.  N=', i12)
 9005 FORMAT (' Zone ', i3, ' Is Too Big.  N=', i12)
 9006 FORMAT (' Cannot Open ', a)
 9007 FORMAT (' GSC Index Error ', 3i12)
 9008 FORMAT (' GSC Repack Error ', 2i12)
c
c...Get Zone And Count
c
  100 WRITE (cz,9002) zone
      CALL f_doenv('UGAPOUT:ring'//cz//'.hdr',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) n,m
      CLOSE (1)
      IF (n.gt.NSMAX) THEN
        WRITE ( *,9005) zone,n
        WRITE (10,9005) zone,n
        RETURN
      ENDIF
c
c...Get DATA
c
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=(3*n),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      CALL gobble3(1,n,bigbuf)
      CLOSE (1)
c
c...Get ZON
c
      lb(nlb-2:nlb) = 'zon'
      OPEN (
     *      access='direct',
     *      carriagecontrol='list',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=(2*m),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      CALL gobble2(1,m,auxtmp)
      CLOSE (1)
      DO i=1,n
        auxvec(i) = 0
      ENDDO
      DO i=1,m
        j = auxtmp(1,i)
        IF ((j.lt.1).or.(j.gt.n)) THEN
          WRITE ( *,9007) i,j,auxtmp(2,i)
          WRITE (10,9007) i,j,auxtmp(2,i)
        ELSE
           auxvec(j) = auxtmp(2,i)
        ENDIF
      ENDDO
c
c...Check It
c
      DO i=2,n
        IF (bigbuf(1,i).lt.bigbuf(1,i-1)) GO TO 110
      ENDDO
      WRITE ( *,9001) zone,n
      WRITE (10,9001) zone,n
      RETURN
c
c...Out Of Order.  Sort It The Long Way
c
  110 WRITE ( *,9004) zone,n
      WRITE (10,9004) zone,n
      DO i=1,n
        zzz(i) = bigbuf(1,i)
        iii(i) = i
      ENDDO
      CALL iuqsrt(n,zzz,iii)
      DO i=1,n
        bigbuf(1,i) = zzz(i)
      ENDDO
      DO j=2,3
        DO i=1,n
          zzz(i) = bigbuf(j,i)
        ENDDO
        DO i=1,n
          bigbuf(j,i) = zzz(iii(i))
        ENDDO
      ENDDO
      DO i=1,n
        zzz(i) = auxvec(i)
      ENDDO
      DO i=1,n
        auxvec(i) = zzz(iii(i))
      ENDDO
c
c...Save New DAT
c
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=(3*n),
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CALL ungobble3(1,n,bigbuf)
      CLOSE (1)
c
c...Regenerate And Save New ZON
c
      j = 0
      DO i=1,n
        IF (auxvec(i).ne.0) THEN
          j = j+1
          auxtmp(1,j) = i
          auxtmp(2,j) = auxvec(i)
        ENDIF
      ENDDO
      IF (j.ne.m) THEN
        WRITE ( *,9008) j,m
        WRITE (10,9008) j,m
      ENDIF
      lb(nlb-2:nlb) = 'zon'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=(2*n),
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CALL ungobble2(1,j,auxtmp)
      CLOSE (1)
      RETURN
c
c...No File
c
  200 WRITE ( *,9006) lb(1:nlb)
      WRITE (10,9006) lb(1:nlb)
      RETURN
      END
