      PROGRAM  checklog
c
c...Look For Bad Checks In RING.LOG File
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 937+100+894,
     *         s_add = 937+100,
     *         tag = 90807.06,
     *         big_bar = 1.5,
     *         big_sig = 6.0
      INTEGER
     *         found(NMAX), i, nlb, field, total, debug, j
      CHARACTER*132
     *         lb
      CHARACTER*1
     *         c
      REAL
     *         oebarx(NMAX), oesigx(NMAX), oebary(NMAX),
     *         oesigy(NMAX), gobarx(NMAX), gosigx(NMAX),
     *         gobary(NMAX), gosigy(NMAX), rdbarx(NMAX),
     *         rdsigx(NMAX), rdbary(NMAX), rdsigy(NMAX),
     *         xb, xs, yb, ys
c
 9000 FORMAT (' >>', a, '<<')
 9001 FORMAT (q, a)
 9002 FORMAT (i3)
 9003 FORMAT (' Error Parsing Field')
 9004 FORMAT (26x, f6.0, 3x, f5.0, 4x, f6.0, 3x, f5.0)
 9005 FORMAT (15x, f6.0, 3x, f5.0, 4x, f6.0, 3x, f5.0)
 9006 FORMAT (' Checking O+E')
 9007 FORMAT (' Checking G+O')
 9008 FORMAT (' Checking RD')
 9009 FORMAT (' Total Fields In RING.LOG=', i5)
 9010 FORMAT (' F=', a, i4.4, '   X=', f6.2, '+/-', f5.2, '   Y=', f6.2,
     *        '+/-', f5.2)
 9011 FORMAT (' Examining File ', a)
 9012 FORMAT (' F=', a, i4.4, '  >>', a, '<<')
c
c...Initialization
c
  100 DO i=1,NMAX
        found(i) = 0
      ENDDO
      CALL f_doenv('UGAPOUT:ring.log',nlb,lb)
      WRITE (*,9011) lb(1:nlb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      field = -1
      debug = 0
c
c...Process Each Useful Line
c
  110 READ (1,9001,end=120) nlb,lb
      IF (nlb.le.1) GO TO 110
c
c...Is This A New Field?
c
      IF (lb(1:5).eq.' UGAP') THEN
        READ (lb(12:14),9002,err=210) i
        IF (lb(7:7).eq.'S') THEN
          field = i+S_ADD
        ELSE
          field = i
        ENDIF
        found(field) = found(field)+1
        oebarx(field) = TAG
        oesigx(field) = TAG
        oebary(field) = TAG
        oesigy(field) = TAG
        gobarx(field) = TAG
        gosigx(field) = TAG
        gobary(field) = TAG
        gosigy(field) = TAG
        rdbarx(field) = TAG
        rdsigx(field) = TAG
        rdbary(field) = TAG
        rdsigy(field) = TAG
      if (field.lt.0) then
      debug = 1
      write (*,9991) field
      elseif (debug.ne.0) then
      debug = 0
      write (*,9992)
      endif
 9991 format (' DEBUG ON F=', i4)
 9992 format (' DEBUG OFF')
c
c...Is This An O+E Result?
c
      ELSEIF (lb(1:5).eq.' O+E ') THEN
        READ (lb(1:nlb),9004,err=110) xb,xs,yb,ys
        oebarx(field) = xb
        oesigx(field) = xs
        oebary(field) = yb
        oesigy(field) = ys
      if (debug.ne.0) then
      write (*,9993) xb,xs,yb,ys
      endif
 9993 format (' O+E', 4f10.2)
c
c...Is This A G+O Result?
c
      ELSEIF (lb(1:5).eq.' G+O ') THEN
        READ (lb(1:nlb),9004,err=110) xb,xs,yb,ys
        gobarx(field) = xb
        gosigx(field) = xs
        gobary(field) = yb
        gosigy(field) = ys
      if (debug.ne.0) then
      write (*,9994) xb,xs,yb,ys
      endif
 9994 format (' G+O', 4f10.2)
c
c...Is This An RD Result?
c
      ELSEIF (lb(1:4).eq.' RD ') THEN
        READ (lb(1:nlb),9005,err=110) xb,xs,yb,ys
        rdbarx(field) = xb
        rdsigx(field) = xs
        rdbary(field) = yb
        rdsigy(field) = ys
      if (debug.ne.0) then
      write (*,9995) xb,xs,yb,ys
      endif
 9995 format (' RD ', 4f10.2)
c
c...Look For Err Lines
c
      ELSEIF (INDEX(lb(1:nlb),'Err').gt.0) THEN
        IF (field.le.1037) THEN
          c = 'N'
          j = field
        ELSE
          c = 'S'
          j = field-1037
        ENDIF
        WRITE (*,9012) c,j,lb(1:nlb)
      ELSEIF (INDEX(lb(1:nlb),'Fail').gt.0) THEN
        IF (field.le.1037) THEN
          c = 'N'
          j = field
        ELSE
          c = 'S'
          j = field-1037
        ENDIF
        WRITE (*,9012) c,j,lb(1:nlb)
c
c...All Done
c
      ENDIF
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9006)
      DO i=1,NMAX
        IF (found(i).gt.0) THEN
          IF ((ABS(oebarx(i)).ge.BIG_BAR)
     *    .or.(    oesigx(i) .ge.BIG_SIG)
     *    .or.(ABS(oebary(i)).ge.BIG_BAR)
     *    .or.(    oesigy(i) .ge.BIG_SIG)) THEN
            IF (i.le.1037) THEN
              c = 'N'
              j = i
            ELSE
              c = 'S'
              j = i-1037
            ENDIF
            WRITE (*,9010) c,j,oebarx(i),oesigx(i),oebary(i),oesigy(i)
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9007)
      DO i=1,NMAX
        IF (found(i).gt.0) THEN
          IF ((ABS(gobarx(i)).ge.BIG_BAR)
     *    .or.(    gosigx(i) .ge.BIG_SIG)
     *    .or.(ABS(gobary(i)).ge.BIG_BAR)
     *    .or.(    gosigy(i) .ge.BIG_SIG)) THEN
            IF (i.le.1037) THEN
              c = 'N'
              j = i
            ELSE
              c = 'S'
              j = i-1037
            ENDIF
            WRITE (*,9010) c,j,gobarx(i),gosigx(i),gobary(i),gosigy(i)
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9008)
      DO i=1,NMAX
        IF (found(i).gt.0) THEN
          IF ((ABS(rdbarx(i)).ge.BIG_BAR)
     *    .or.(    rdsigx(i) .ge.BIG_SIG)
     *    .or.(ABS(rdbary(i)).ge.BIG_BAR)
     *    .or.(    rdsigy(i) .ge.BIG_SIG)) THEN
            IF (i.le.1037) THEN
              c = 'N'
              j = i
            ELSE
              c = 'S'
              j = i-1037
            ENDIF
            WRITE (*,9010) c,j,rdbarx(i),rdsigx(i),rdbary(i),rdsigy(i)
          ENDIF
        ENDIF
      ENDDO
      total = 0
      DO i=1,NMAX
        IF (found(i).gt.0) THEN
          total = total+1
        ENDIF
      ENDDO
      WRITE (*,9009) total
      CALL EXIT
c
c...Parse Error Recovery
c
  210 WRITE (*,9003)
      WRITE (*,9000) lb(1:nlb)
      GO TO 110
      END
