      SUBROUTINE  nodup
c
c...Remove Duplicate Entries
c
      INCLUDE
     *            'ugap4.inc'
      PARAMETER
     *            todegree = ((3600*100)/1000),
     *            nfmax = 100
      INTEGER
     *            test, low1, high1, low2, high2, dx, dy, rsqr, q,
     *            x, y, xl, xh, yl, yh, last1, last2, p, nfind, ex, ey,
     *            ifind(NFMAX), jfind(NFMAX), er, ntag, mfind(NFMAX),
     *            ntnew, ntold
      DOUBLE PRECISION
     *            cosdec
c
 9001 FORMAT (' NODUP Removed ', i12)
 9002 FORMAT (' Tag Check', 4i12)
 9003 FORMAT (' Too Many In NODUP', 5i12)
c
c...Initializations
c
  100 test = s1frst(2)-1
      low1 = 1
      high1 = 1
      last1 = s1last(3)
      low2 = 1
      high2 = 1
      last2 = s2last(3)
      dy = radius*ARCSEC + 0.5D00
      rsqr = dy*dy
      ntag = 0
      ntold = 0
c
c...Outer Loop Over Tested Star
c
  110 test = test+1
      IF (test.gt.s1last(2)) GO TO 200
      IF (z1(1,test).eq.TAG) GO TO 110
      q = z1(2,test)/TODEGREE
      cosdec = cd(q+1)
      dx = radius*ARCSEC/cosdec + 0.5
      x = z1(1,test)
      y = z1(2,test)
      xl = x-dx
      xh = x+dx
      yl = y-dy
      yh = y+dy
c
c...Look For LOW Limit
c
  120 q = z1(1,low1)
      IF (q.ne.TAG) THEN
        IF (q.ge.xl) GO TO 130
      ENDIF
      low1 = low1+1
      IF (low1.le.last1) GO TO 120
  130 q = z2(1,low2)
      IF (q.ne.TAG) THEN
        IF (q.ge.xl) GO TO 140
      ENDIF
      low2 = low2+1
      IF (low2.le.last2) GO TO 130
  140 CONTINUE
c
c...Look For HIGH Limit
c
      IF (low1.le.last1) THEN
        high1 = MAX(high1,low1)
        DO p=high1+1,last1
          q = z1(1,p)
          IF (q.ne.TAG) THEN
            IF (q.le.xh) THEN
              high1 = p
            ELSE
              GO TO 150
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  150 IF (low2.le.last2) THEN
        high2 = MAX(high2,low2)
        DO p=high2+1,last2
          q = z2(1,p)
          IF (q.ne.TAG) THEN
            IF (q.le.xh) THEN
              high2 = p
            ELSE
              GO TO 160
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  160 CONTINUE
c
c...Range From LOW to HIGH Needs To Be Examined
c
      nfind = 0
      IF (low1.le.last1) THEN
        nfind = 1
        ifind(nfind) = test
        jfind(nfind) = 1
        mfind(nfind) = z1(3,test)
        DO p=low1,high1
          IF (p.ne.test) THEN
            IF (z1(1,p).ne.TAG) THEN
              ex = ABS(z1(1,p)-x)*cosdec + 0.5D00
              ey = ABS(z1(2,p)-y)
              IF ((ex.le.dy).and.(ey.le.dy)) THEN
                er = ex*ex + ey*ey
                IF (er.le.rsqr) THEN
                  nfind = nfind+1
                  ifind(nfind) = p
                  jfind(nfind) = 1
                  mfind(nfind) = z1(3,p)
                  IF (nfind.ge.NFMAX) GO TO 170
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  170 IF (low2.le.last2) THEN
        DO p=low2,high2
          IF (z2(1,p).ne.TAG) THEN
            ex = ABS(z2(1,p)-x)*cosdec + 0.5D00
            ey = ABS(z2(2,p)-y)
            IF ((ex.le.dy).and.(ey.le.dy)) THEN
              er = ex*ex + ey*ey
              IF (er.le.rsqr) THEN
                nfind = nfind+1
                ifind(nfind) = p
                jfind(nfind) = 2
                mfind(nfind) = z2(3,p)
                IF (nfind.ge.NFMAX) GO TO 180
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  180 CONTINUE
      IF (nfind.ge.NFMAX) THEN
        WRITE (*,9003) nfind,low1,high1,low2,high2
        WRITE (2,9003) nfind,low1,high1,low2,high2
      ENDIF
c
c...Put Selection Logic Somewhere Else
c
      IF (nfind.gt.1) THEN
        CALL select(nfind,ifind,jfind,mfind)
        ntag = ntag + (nfind-1)
        ntnew = ntag/100000
        IF (ntnew.ne.ntold) THEN
          WRITE (*,9002) test,ntag,ntag1,ntag2
          WRITE (2,9002) test,ntag,ntag1,ntag2
          ntold = ntnew
        ENDIF
      ENDIF
      GO TO 110
c
c...All Done
c
  200 WRITE (*,9001) ntag
      WRITE (2,9001) ntag
      RETURN
      END
