      PROGRAM  count
c
c...Just Count Images
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nx = 360,
     *         ny = 180
      INTEGER
     *         imin(NX,NY), imout(NX,NY), x, y, nin, nout, nraw,
     *         inmin, inmax, outmin, outmax
      REAL
     *         ymin, ymax, dmin, dmax
c
 9001 FORMAT (' Nin=', i12, '   Nout=', i12, '   Nraw=', i12)
 9002 FORMAT (' In(min)=', i8, '  In(max)=', i8, '  Out(min)=',
     *        i8, '  Out(max)=', i8)
c
  100 OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='ugap4x.dat',
     *      readonly,
     *      recl=(NX*NY),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) imin
      READ (1,rec=2) imout
      CLOSE (1)
      nin = 0
      nout = 0
      inmin = imin(1,1)
      inmax = inmin
      outmin = imout(1,1)
      outmax = outmin
      ymin = 1
      ymax = 1
      DO y=1,NY
        DO x=1,NX
          nin = nin+imin(x,y)
          nout = nout+imout(x,y)
          outmin = MIN(outmin,imout(x,y))
          outmax = MAX(outmax,imout(x,y))
          IF (imin(x,y).lt.inmin) THEN
            inmin = imin(x,y)
            ymin = y
          ENDIF
          IF (imin(x,y).gt.inmax) THEN
            inmax = imin(x,y)
            ymax = y
          ENDIF
        ENDDO
      ENDDO
      nraw = nin+nout
      WRITE (*,9001) nin,nout,nraw
      dmin = ymin - (NY+1)/2.0
      write (*,9991) ymin,dmin,inmin
 9991 format (2f10.3, i10)
      inmin = inmin/COSD(dmin)
      dmax = ymax - (NY+1)/2.0
      write (*,9991) ymax,dmax,inmax
      inmax = inmax/COSD(dmax)
      WRITE (*,9002) inmin,inmax,outmin,outmax
      CALL EXIT
      END
