      SUBROUTINE  prelim(zone,done)
c
c...Read The ACC and TAG Files
c
      INCLUDE
     *            'ugap5.inc'
      PARAMETER
     *            ndir = 1
      INTEGER
     *            zone, i, j, C_GENLEN, C_OPENER, done
      CHARACTER*4
     *            cz
      CHARACTER*3
     *            dir(NDIR)
      BYTE
     *            bb(65)
      DATA
     *     dir/'uv6'/
c
 9001 FORMAT (i4.4)
 9002 FORMAT (5x, 2i12)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (' Too Many Tags', 2i12)
 9005 FORMAT (' Illegal TAG File Length', 2i12)
 9006 FORMAT (' Illegal LUT File Length', 2i12)
 9007 FORMAT (' Too Many LUTs', 2i12)
 9008 FORMAT (' Zone ', i4, '  NTAG=', i12)
 9009 FORMAT (' Zone ', i4, '  NLUT=', i12)
c
c...Look various places and save the name
c
  100 WRITE (cz,9001) zone
      DO i=1,ndir
        root = '/'//dir(i)//'/xpmm/zone/zone'//cz//'.acc'
        nroot = 27
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=110,
     *        form='formatted',
     *        name=root(1:nroot),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO j=1,NRA
          READ (1,9002) ff(j),ll(j)
        ENDDO
        CLOSE (1)
        GO TO 120
  110   CONTINUE
      ENDDO
      WRITE (*,9003) root(1:nroot)
      WRITE (3,9003) root(1:nroot)
      CALL EXIT
c
c...Load All Known Tags
c
  120 CALL f_doenv('UGAPTAG:zone'//cz//'.tag',ntname,tname)
      DO i=1,ntname
        bb(i) = ICHAR(tname(i:i))
      ENDDO
      bb(ntname+1) = 0
      ntag = C_GENLEN(bb)
      IF (MOD(ntag,4).ne.0) GO TO 200
      ntag = ntag/4
      IF (ntag.gt.NTMAX) THEN
        WRITE (*,9004) zone,ntag
        WRITE (3,9004) zone,ntag
        CALL EXIT
      ENDIF
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tname(1:ntname),
     *      readonly,
     *      recl=ntag,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (tag(i),i=1,ntag)
      CLOSE (1)
      WRITE (*,9008) zone,ntag
      WRITE (3,9008) zone,ntag
c
c...Load The GSC LookUp Table
c
      root(nroot-2:nroot) = 'lut'
      DO i=1,nroot
        bb(i) = ICHAR(root(i:i))
      ENDDO
      bb(nroot+1) = 0
      nlut = C_GENLEN(bb)
      IF (MOD(nlut,8).ne.0) GO TO 210
      nlut = nlut/4
      IF (nlut.gt.(2*NLMAX)) THEN
        WRITE (*,9007) zone,nlut
        WRITE (3,9007) zone,nlut
        CALL EXIT
      ENDIF
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=210,
     *      form='unformatted',
     *      name=root(1:nroot),
     *      readonly,
     *      recl=nlut,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (vlut(i),i=1,nlut)
      CLOSE (1)
      nlut = nlut/2
      WRITE (*,9009) zone,nlut
      WRITE (3,9009) zone,nlut
c
c...Open The Output FAT File
c
      CALL f_doenv('UGAPTAG:ugap5.fat',nxb,xb)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='delete',
     *      err=130,
     *      form='unformatted',
     *      name=xb(1:nxb),
     *      recl=3,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CLOSE (1)
  130 DO i=1,nxb
        bb(i) = ICHAR(xb(i:i))
      ENDDO
      bb(nxb+1) = 0
      ofd = C_OPENER(bb)
      IF (ofd.le.2) THEN
        WRITE (*,9003) xb(1:nxb)
        WRITE (3,9003) xb(1:nxb)
        CALL EXIT
      ENDIF
c
c...Open The Output FUT File
c
      xb(nxb-2:nxb) = 'fut'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='delete',
     *      err=140,
     *      form='unformatted',
     *      name=xb(1:nxb),
     *      recl=2,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CLOSE (1)
  140 DO i=1,nxb
        bb(i) = ICHAR(xb(i:i))
      ENDDO
      bb(nxb+1) = 0
      lfd = C_OPENER(bb)
      IF (lfd.le.2) THEN
        WRITE (*,9003) xb(1:nxb)
        WRITE (3,9003) xb(1:nxb)
        CALL EXIT
      ENDIF
c
c...Other Stuff
c
      DO i=1,NRA
        razfrst(i) = 0
        razlen(i) = 0
      ENDDO
      razold = -1
      nltotal = 0
      nototal = 0
      done = 0
      RETURN
c
c...Errors.  Note.  RENAME moves TAG files to RAG files, so a TAG file
c		error means that this zone has been done.
c
  200 WRITE (*,9005) zone,ntag
      done = 1
      RETURN
  210 WRITE (*,9006) zone,nlut
      CALL EXIT
      END
