      SUBROUTINE  loadcoef
c
c...Load The Plate-to-Plate Calibration Coefficients
c
      INCLUDE
     *            'ugap7.inc'
      INTEGER
     *          nlb, i, k, jb, jr
      DOUBLE PRECISION
     *          cc(NCMAX), dd(NCMAX)
      CHARACTER*64
     *          lb
c
 9001 FORMAT (i4, 2i3, 30x, 10(1x,1pe11.4))
 9002 FORMAT (' Missing Calibration For Field ', i4)
 9003 FORMAT (' Cannot Open ', a)
c
c...Process NORTH
c
  100 DO i=1,NP1
        nbpoly(i) = 0
        nrpoly(i) = 0
      ENDDO
      lb = 'calcoef.17'
      nlb = 10
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
      nbpoly(i) = jb
      DO k=1,jb
        bpoly(k,i) = cc(k)
      ENDDO
      nrpoly(i) = jr
      DO k=1,jr
        rpoly(k,i) = dd(k)
      ENDDO
      CALL reversion(nbpoly(i),bpoly(1,i))
      CALL reversion(nrpoly(i),rpoly(1,i))
      GO TO 110
  120 CLOSE (1)
c
c...Process SOUTH
c
      lb = 'soucoef.17'
      nlb = 10
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9001,end=140) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
      nbpoly(i) = jb
      DO k=1,jb
        bpoly(k,i) = cc(k)
      ENDDO
      nrpoly(i) = jr
      DO k=1,jr
        rpoly(k,i) = dd(k)
      ENDDO
      CALL reversion(nbpoly(i),bpoly(1,i))
      CALL reversion(nrpoly(i),rpoly(1,i))
      GO TO 130
  140 CLOSE (1)
c
c...Final Sanity Check.  Make Sure That All Fields Are Here
c
      k = 0
      DO i=1,937
        IF (i.ne.723) THEN
          IF ((nbpoly(i).eq.0).or.(nrpoly(i).eq.0)) THEN
            k = 1
            WRITE (*,9002) i
          ENDIF
        ENDIF
      ENDDO
      DO i=1037+1,1037+408
        IF ((nbpoly(i).eq.0).or.(nrpoly(i).eq.0)) THEN
          k = 1
          WRITE (*,9002) i
        ENDIF
      ENDDO
      IF (k.ne.0) THEN
        CALL EXIT
      ENDIF
      RETURN
c
c...Big Problem
c
  200 WRITE (*,9003) lb(1:nlb)
      CALL EXIT
      END
