      SUBROUTINE  nmag(field,jb,jr)
c
c...Calibrate North Magnitudes
c
      INCLUDE
     *            'ugap7.inc'
      INTEGER
     *            field, i, ix, ib, ir, jb, jr
      DOUBLE PRECISION
     *            mb, mr, bhat, rhat, dv, bres, rres
c
 9001 FORMAT (' Illegal NMAG Field=', i4)
c
c...Sanity Checks
c
  100 IF ((field.lt.1).or.(field.gt.937).or.(field.eq.723)) THEN
        WRITE (*,9001) field
        WRITE (3,9001) field
        RETURN
      ENDIF
      ix = field
c
c...Process Both
c
      bhat = 0.0D00
      dv = 1.0D00
      mb = 0.1D00*jb
      IF (nbpoly(ix).eq.1) THEN
        bhat = mb + bpoly(1,ix)
      ELSE
        DO i=1,nbpoly(ix)
          bhat = bhat + dv*bpoly(i,ix)
          dv = dv*mb
        ENDDO
      ENDIF
      rhat = 0.0D00
      dv = 1.0D00
      mr = 0.1D00*jr
      IF (nrpoly(ix).eq.1) THEN
        rhat = mr + rpoly(1,ix)
      ELSE
        DO i=1,nrpoly(ix)
          rhat = rhat + dv*rpoly(i,ix)
          dv = dv*mr
        ENDDO
      ENDIF
      bres = bhat
      rres = rhat
      ib = 100.0D00*bres + 0.5D00
      IF (ib.lt.1) THEN
        ib = nblut(1)
      ELSEIF (ib.gt.NMAGLUT) THEN
        ib = nblut(NMAGLUT)
      ELSE
        ib = nblut(ib)
      ENDIF
      IF ((mb.ge.0.0D00).and.(mb.le.25.0D00)) THEN
        jb = (ib+5)/10
      ENDIF
      ir = 100.0D00*rres + 0.5D00
      IF (ir.lt.1) THEN
        ir = nrlut(1)
      ELSEIF (ir.gt.NMAGLUT) THEN
        ir = nrlut(NMAGLUT)
      ELSE
        ir = nrlut(ir)
      ENDIF
      IF ((mr.ge.0.0D00).and.(mr.le.25.0D00)) THEN
        jr = (ir+5)/10
      ENDIF
      RETURN
      END
