      SUBROUTINE  okproc(who)
c
c...Calibrate PIPROG OK Files
c
c	Note.  ZONE is fake needed to make CALIBRATE() assume a North field.
c
c	Note.  TOORED and TOOBLUE should agree with TCSELECT()
c
      INCLUDE
     *            'ugap7.inc'
      PARAMETER
     *            zone = 900,
     *            tooblue = 0.5,
     *            toored = 1.2
      CHARACTER*(*)
     *            who
      INTEGER
     *            nfn, nlb, field, b, r, fake, id, source
      REAL
     *            mag, true, color
      CHARACTER*200
     *            fn, lb
c
 9001 FORMAT (q, a)
 9002 FORMAT (i5, 3f8.0, 10(8x), 2i8)
 9003 FORMAT (3f8.2, 3i8)
 9005 FORMAT (' WHO=', a, '  Working On ', a)
c
c...Get List And Process Each
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugap7b.'//who,
     *      status='unknown',
     *      unit=3
     *     )
      IF (who.eq.'b') THEN
        CALL system('\ls $PIPROG/*.bok >okproc.inp')
      ELSE
        CALL system('\ls $PIPROG/*.rok >okproc.inp')
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='okproc.inp',
     *      status='old',
     *      unit=2
     *     )
  110 READ (2,9001,end=140) nfn,fn
      WRITE (*,9005) who,fn(1:nfn)
c
c...Process Each Star
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=fn(1:nfn),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  120 READ (1,9001,end=130) nlb,lb
      READ (lb(1:nlb),9002) id,true,mag,color,source,field
      IF (who.eq.'b') THEN
        b = 10.0*mag + 0.5
        r = 999
      ELSE
        b = 999
        r = 10.0*mag + 0.5
      ENDIF
      fake = field*MILLION + b*THOUSAND + r
      CALL calibrate(ZONE,fake)
      field = fake/MILLION
      fake= fake - field*MILLION
      b = fake/THOUSAND
      r = fake - b*THOUSAND
      IF (who.eq.'b') THEN
        mag = 0.1*b
      ELSE
        mag = 0.1*r
      ENDIF
      IF (source.eq.1) THEN
        WRITE (3,9003) true,mag,color,id,source,field
      ELSE
        IF ((color.ge.TOOBLUE).and.(color.le.TOORED)) THEN
          WRITE (3,9003) true,mag,color,id,source,field
        ENDIF
      ENDIF
      GO TO 120
c
c...End Of Processing Loop
c
  130 CLOSE (1)
      GO TO 110
  140 CLOSE (2)
      CLOSE (3)
      RETURN
      END
