      SUBROUTINE  zoneproc
c
c...Transform ZONE Stars
c
      INCLUDE
     *            'ugap7.inc'
      PARAMETER
     *            nacc = 96
      INTEGER
     *            zone, i, val, nsrc, ntmp, each(3),
     *            ndst, frst(NACC), len(NACC), m, C_GENLEN
      CHARACTER*4
     *            cz
      CHARACTER*64
     *            src, tmp, dst
      BYTE
     *            bb(65)
c
 9001 FORMAT (i4.4)
 9002 FORMAT (2i10)
 9004 FORMAT (' Working On Zone ', i4)
 9005 FORMAT (' Illegal File Length=', i12, ' >>', a)
 9006 FORMAT (5x, 2i12)
 9007 FORMAT (' CAT and ACC Disagree', 2i12, ' >>', a)
c
c...Outer Loop Is Over Zone
c
  100 DO zone=0,1725,75
        WRITE (*,9004) zone
        WRITE (cz,9001) zone
        src = '/uv6/xpmm/zone/zone'//cz//'.cat'
        nsrc = 27
        tmp = '/uu6/xpmm/v1.0/zone.tmp'
        ntmp = 23
        dst = '/uu6/xpmm/v1.0/zone'//cz//'.cat'
        ndst = 27
c
c...Get Byte Count Of Source CAT File
c
        src(nsrc-2:nsrc) = 'cat'
        DO i=1,nsrc
          bb(i) = ICHAR(src(i:i))
        ENDDO
        bb(nsrc+1) = 0
        nbyte = C_GENLEN(bb)
        IF (MOD(nbyte,12).ne.0) THEN
          WRITE (*,9005) nbyte,src(1:nsrc)
          WRITE (3,9005) nbyte,src(1:nsrc)
          CALL EXIT
        ENDIF
c
c...Ingest The ACC File, Verify The Count, And Copy
c
        src(nsrc-2:nsrc) = 'acc'
        dst(ndst-2:ndst) = 'acc'
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=src(1:nsrc),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,NACC
          READ (1,9006) frst(i),len(i)
        ENDDO
        CLOSE (1)
        m = frst(NACC)+len(NACC)-1
        IF (nbyte.ne.(12*m)) THEN
          WRITE (*,9007) nbyte,m,src(1:nsrc)
          WRITE (3,9007) nbyte,m,src(1:nsrc)
          CALL EXIT
        ENDIF
        CALL system('cp '//src(1:nsrc)//' '//dst(1:ndst))
c
c...Copy The LUT File
c
        src(nsrc-2:nsrc) = 'lut'
        dst(ndst-2:ndst) = 'lut'
        CALL system('cp '//src(1:nsrc)//' '//dst(1:ndst))
c
c...Process The CAT File Piece At A Time
c
        src(nsrc-2:nsrc) = 'cat'
        dst(ndst-2:ndst) = 'cat'
        CALL system('rm '//tmp(1:ntmp)//' '//dst(1:ndst))
        CALL openzd(src(1:nsrc))
        CALL openxd(tmp(1:ntmp))
        DO i=1,m
          CALL nextzd(each)
          CALL calibrate(zone,each(3))
          CALL nextxd(each)
        ENDDO
        CALL c_closer(srcfd)
        CALL c_closer(tmpfd)
        CALL system('mv '//tmp(1:ntmp)//' '//dst(1:ndst))
      ENDDO
      RETURN
      END
