      PROGRAM  ugap8c
c
c...See If Everyting Is OK And Save The ACC File
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nchunk = 2*1000*1000,
     *         nacc = 96,
     *         convert = 15*3600*100/4
      INTEGER
     *         buf(3,NCHUNK), vec(3*NCHUNK), nlb, nn, zone, i, mm,
     *         rmin, rmax, smin, smax, nomit, mmin, mmax, IARGC, j,
     *         nrec, nmost, nlast, fd, C_ROOPEN, C_READER, cur,
     *         nlut, lut(2,NCHUNK), vlut(2*NCHUNK), C_GENLEN, lonold,
     *         accfrst(NACC), acclen(NACC), iacc, lon, count, total,
     *         totalnn
      REAL
     *         z
      CHARACTER*64
     *         lb
      CHARACTER*4
     *         cz
      BYTE
     *         bb(65)
      EQUIVALENCE
     *         (buf(1,1),vec(1)),
     *         (lut(1,1),vlut(1))
c
 9001 FORMAT (i4.4)
 9003 FORMAT (i4)
 9004 FORMAT (2i10)
 9005 FORMAT (' Cannot Open ', a)
 9006 FORMAT (' Read Length Error', 2i12)
 9007 FORMAT (' OOO ', 5i12)
 9008 FORMAT (' Chunk (', i3, '/', i3, ') N=', 3i12)
 9009 FORMAT (f5.2, 2i12)
 9010 FORMAT (' Zone=', i4, '   N=', i12)
 9011 FORMAT (' Illegal LUT', i12)
 9012 FORMAT (' NLUT=', i12, '  NNEG=', i12, ' Diff=', i12)
 9013 FORMAT (' Illegal Byte Length', i12)
 9014 FORMAT (' Illegal ACC Count', 3i12)
 9015 FORMAT (' Illegal NACC', 2i12)
c
c...Loop Over Zones
c
  100 DO zone=0,1725,75
        WRITE (cz,9001) zone
        lb = '/ux6/xpmm/zone/lbzn'//cz//'.cat'
        nlb = 27
        DO i=1,nlb
          bb(i) = ICHAR(lb(i:i))
        ENDDO
        bb(nlb+1) = 0
        total = C_GENLEN(bb)
        IF ((total.le.0).or.(MOD(total,12).ne.0)) THEN
          WRITE (*,9013) nn
          CALL EXIT
        ENDIF
        total = total/12
c
c...Use C Interface So We Can Read CHUNK At A Time
c
        fd = C_ROOPEN(bb)
        IF (fd.lt.3) THEN
          WRITE (*,9005) lb(1:nlb)
          CALL EXIT
        ENDIF
        nrec = ((total-1)/NCHUNK) + 1
        nmost = NCHUNK
        nlast = total - (nrec-1)*nmost
        cur = 0
        lonold = -1
        iacc = 0
        count = 0
        totalnn = 0
c
c...Chunk By Chunk Examination
c
  120   cur = cur+1
        IF (cur.eq.nrec) THEN
          nn = nlast
        ELSE
          nn = nmost
        ENDIF
        j = C_READER(fd,buf,12*nn)
        WRITE (*,9008) cur,nrec,nn,buf(1,1),buf(1,nn)
        IF (j.ne.0) THEN
          WRITE (*,9006) j,nn
          CALL EXIT
        ENDIF
        DO i=1,nn
          totalnn = totalnn+1
          lon = buf(1,i)/CONVERT
          IF (lon.lt.lonold) THEN
            WRITE (*,9007) zone,i,lonold,lon
            WRITE (*,9007) zone,i,buf(1,i),buf(2,i),buf(3,i)
      pause 'Out Of Order'
          ELSEIF (lon.eq.lonold) THEN
            count = count+1
          ELSE
            IF (iacc.gt.0) THEN
              acclen(iacc) = count
            ENDIF
            iacc = iacc+1
            accfrst(iacc) = totalnn
            count = 1
            lonold = lon
          ENDIF
          IF (i.gt.1) THEN
            IF (buf(1,i).lt.buf(1,i-1)) THEN
              DO j=i-5,i+5
                WRITE (*,9007) zone,j,buf(1,j),buf(2,j),buf(3,j)
              ENDDO
      pause 'Out Of Order'
            ENDIF
            IF ((buf(1,i)-buf(1,i-1)).gt.100000) THEN
              DO j=i-5,i+5
                WRITE (*,9007) zone,j,buf(1,j),buf(2,j),buf(3,j)
              ENDDO
      pause 'Big Gap'
            ENDIF
          ENDIF
        ENDDO
        IF (cur.lt.nrec) GO TO 120
        CALL c_closer(fd)
c
c...Scribble ACC File
c
        acclen(iacc) = count
        IF (iacc.ne.NACC) THEN
          WRITE (*,9015) iacc,NACC
          CALL EXIT
        ENDIF
        IF ((accfrst(NACC)+acclen(NACC)-1).ne.total) THEN
          WRITE (*,9014) accfrst(NACC),acclen(NACC),total
          CALL EXIT
        ENDIF
        lb(nlb-2:nlb) = 'acc'
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        status='unknown',
     *        unit=1
     *       )
        DO i=1,NACC
          z = 0.25*(i-1)
          WRITE (1,9009) z,accfrst(i),acclen(i)
        ENDDO
        CLOSE (1)
      ENDDO
      CALL EXIT
      END
