      SUBROUTINE  binfill(in,xout,yout,dfout,edfout)
c
c...Crack Values And Put In Passing Vector
c
      INCLUDE
     *            'ridge.inc'
      INTEGER
     *            in(*), low, mid, high, j, nin, nsat, radii(8),
     *            nt, nc, nb, foot
      DOUBLE PRECISION
     *            xout, yout(*), dfout(*), edfout(*), pmmx, pmmy
      REAL
     *            ccdx, ccdy, mag, m9, r0, s0, grad, amp, sky, good,
     *            rad, m00, m10, m01, m20, m11, m02, tmag, d10, d01,
     *            d20, d11, d02
c
c...Crack X,Y
c
  100 pmmx = 0.01D00*in(9)
      pmmy = 0.01D00*in(10)
c
c...Crack CCD X,Y
c
      j = in(13)
      high = j/(NCOLS*NROWS)
      j = j - high*NCOLS*NROWS
      mid = j/NCOLS
      low = j - mid*NCOLS
      ccdx = low
      ccdy = mid
      foot = high
c
c...Crack Magnitudes
c
      j = in(4)
      high = j/10000
      low = j - high*10000
      mag = 0.01*low
      m9 = 0.01*high
c
c...Crack Amp and Sky
c
      j = in(1)
      high = j/10000
      low = j - high*10000
      high = MOD(high,10000)
      amp = 0.1*low - 100.0
      sky = 0.1D00*high - 100.0D00
c
c...Crack R0 and S0
c
      j = in(2)
      high = j/10000
      low = j - high*10000
      high = MOD(high,10000)
      r0 = 0.1D00*high
      s0 = 0.1D00*low
c
c...Crack Gradient and Goodness of Fit
c
      j = in(3)
      high = j/10000
      grad = MOD(in(11),1000)
      good = 0.1D00*high
c
c...Crack Numper of Pixels
c
      j = in(8)
      high = j/10000
      low = j - high*10000
      nin = low
      nsat = high
c
c...Crack Radii
c
      j = MOD(in(5),100000000)
      radii(4) = j/1000000
      j = j - radii(4)*1000000
      radii(3) = j/10000
      j = j - radii(3)*10000
      radii(2) = j/100
      radii(1) = j - radii(2)*100
      CALL iuqsrt(4,radii,idx)
      rad = radii(3)
c
c...Crack M00,M10,M01
c
      j = in(11)
      high = j/1000000
      j = j - high*1000000
      mid = j/1000
      j = in(1)/100000000
      m00 = 10.0**(0.001*MOD(in(3),10000))
      IF (IAND(j,1).ne.0) THEN
        m00 = -m00
      ENDIF
      m10 = 10.0**(0.01*mid)
      IF (IAND(j,2).ne.0) THEN
        m10 = -m10
      ENDIF
      m01 = 10.0**(0.01*high)
      IF (IAND(j,4).ne.0) THEN
        m01 = -m01
      ENDIF
c
c...Crack M20,M11,M02
c
      j = in(12)
      high = j/1000000
      j = j - high*1000000
      mid = j/1000
      low = j - mid*1000
      j = in(2)/100000000
      m20 = 10.0**(0.01*low)
      IF (IAND(j,1).ne.0) THEN
        m20 = -m20
      ENDIF
      m11 = 10.0**(0.01*mid)
      IF (IAND(j,2).ne.0) THEN
        m11 = -m11
      ENDIF
      m02 = 10.0**(0.01*high)
      IF (IAND(j,4).ne.0) THEN
        m02 = -m02
      ENDIF
c
c...Crack Blobs
c
      j = in(7)
      high = j/10000
      j = j - high*10000
      mid = j/100
      low = j - mid*100
      nt = low
      nc = mid
      nb = high
c
c...Crack Extra Stuff
c
      j = in(6)
      high = j/1000000
      j = j - high*1000000
      mid = j/1000
      low = j - mid*1000
      lumpy = 0.1*low
      mpr = 10.0**(0.01*mid)
      j = in(5)/100000000
      IF (IAND(j,1).ne.0) THEN
        mpr = -mpr
      ENDIF
      mmr = 10.0**(0.01*high)
      IF (IAND(j,2).ne.0) THEN
        mmr = -mmr
      ENDIF
c
c...Fake TMAG From Moments.  NOTICE:  Won't be accurate unless we read
c	MAGOFFSET and MAGSLOPE from .INF file.
c
      IF (m00.ge.1.0) THEN
        tmag = magoffset + magslope*LOG10(m00)
      ELSEIF (m00.le.-1.0) THEN
        tmag = magoffset + magslope*LOG10(-m00) + 50.0
      ELSE
        tmag = 50.0
      ENDIF
c
c...Compute Normalized Moments.  Note that M00 can never be zero since logic
c	in MARGMOMENT makes sure.  But it can be negative.
c
      d10 = m10/m00
      d01 = m01/m00
      d20 = m20/m00
      d11 = m11/m00
      d02 = m02/m00
c
c...Fill Outputs
c
      xout = mag
      yout(1) = m9-mag
      yout(2) = r0
      yout(3) = s0
      yout(4) = rad
      yout(5) = grad
      yout(6) = tmag-mag
      yout(7) = SQRT(d10*d10 + d01*d01)
c
c...MOST IMPORTANT.  INDICATE NUMBER OF ENTRIES
c
      nr = 7
      DO j=1,nr
        dfout(j) = 1.0D00
        edfout(j) = 1.0D00
      ENDDO
      RETURN
      END
