      SUBROUTINE  fitsit(nx,ny,im,dolog)
c
c...Simple FITS Writer
c
      INCLUDE
     *            'square.inc'
      PARAMETER
     *            nhead = 6
      INTEGER
     *            nx, ny, im(nx,ny), nlb, fd, err, C_OPENER, i, j,
     *            C_WRITER, C_RAWWRITER, nzero, dolog
      REAL
     *            z
      CHARACTER*80
     *            lb
      BYTE
     *            bb(80)
c
 9001 FORMAT ('SIMPLE  =                    T')
 9002 FORMAT ('BITPIX  =                   32')
 9003 FORMAT ('NAXIS   =                    2')
 9004 FORMAT ('NAXIS1  = ', 16x, i4)
 9005 FORMAT ('NAXIS2  = ', 16x, i4)
 9006 FORMAT ('END                           ')
 9010 FORMAT (' Enter Output FITS File Name: ' $)
 9011 FORMAT (q, a)
 9012 FORMAT (' Cannot Open ', a)
 9013 FORMAT (' Fatal Error Writing FITS File=', i10)
c
c...Get File Name And Open It Under C
c
  100 WRITE (*,9010)
      READ  (*,9011,err=100,end=200) nlb,lb
      IF (nlb.le.0) GO TO 100
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      fd = C_OPENER(bb)
      IF (fd.le.2) THEN
        WRITE (*,9012) lb(1:nlb)
        GO TO 100
      ENDIF
c
c...Scribble The Header
c
      DO i=1,NHEAD
        IF (i.eq.1) THEN
          WRITE (lb,9001)
        ELSEIF (i.eq.2) THEN
          WRITE (lb,9002)
        ELSEIF (i.eq.3) THEN
          WRITE (lb,9003)
        ELSEIF (i.eq.4) THEN
          WRITE (lb,9004) nx
        ELSEIF (i.eq.5) THEN
          WRITE (lb,9005) ny
        ELSE
          WRITE (lb,9006)
        ENDIF
        DO j=1,80
          bb(j) = ICHAR(lb(j:j))
        ENDDO
        err = C_RAWWRITER(fd,bb,80)
        IF (err.ne.0) GO TO 210
      ENDDO
      DO i=1,80
        bb(i) = 0
      ENDDO
      DO i=NHEAD+1,36
        err = C_RAWWRITER(fd,bb,80)
        IF (err.ne.0) GO TO 210
      ENDDO
c
c...Transform and Scribble The Data
c
      nzero = 0
      IF (dolog.ne.0) THEN
        DO j=1,ny
          DO i=1,nx
            IF (im(i,j).le.0) THEN
              im(i,j) = -1
              nzero = nzero+1
            ELSE
              z = im(i,j)
              im(i,j) = 1000.0*LOG10(z)
            ENDIF
          ENDDO
        ENDDO
      ENDIF
      err = C_WRITER(fd,im,4*nx*ny)
      IF (err.ne.0) GO TO 210
      CALL c_closer(fd)
      write (*,9991) nzero
 9991 format (' NZero=', i10)
      RETURN
c
c...Various Errors
c
  200 RETURN
  210 WRITE (*,9013) err
      CALL c_closer(fd)
      RETURN
      END
