      SUBROUTINE  xycorner(r,d,s)
c
c...Get Corners On The Basis Of (Xi,Eta) And Compute Search Parameters
c
c	WARNING - Uses SLALIB
c
      INCLUDE
     *            'square.inc'
      DOUBLE PRECISION
     *            r, d, s, rd, r1, r2, d1, d2, cd, zmin, zmax,
     *            radian, radr, radd, rads, r3, r4, d3, d4, pi,
     *            rmin, rmax, dmin, dmax, q
      INTEGER
     *            i, j, z1, z2
c
 9001 FORMAT (' Illegal Input: R=', f10.6, '  D=', f10.6)
 9002 FORMAT (' Illegal Size=', f10.6)
c
c...Sanity Checks
c
  100 IF ((r.lt.0.0D00).or.(r.ge.24.0D00)) THEN
        WRITE (*,9001) r,d
        CALL EXIT(0)
      ENDIF
      IF ((d.le.-90.0D00).or.(d.ge.90.0D00)) THEN
        WRITE (*,9001) r,d
        CALL EXIT(0)
      ENDIF
      IF (s.le.0.0D00) THEN
        WRITE (*,9002) s
        CALL EXIT(0)
      ENDIF
c
c...Use SLALIB To Get Corners
c
      pi = 4.0D00*ATAN(1.0D00)
      radian = 180.0D00/pi
      radr = (r*15.0D00)/radian
      radd = d/radian
      rads = s/radian
      CALL sla_DTP2S(-rads,-rads,radr,radd,r1,d1)
      CALL sla_DTP2S( rads,-rads,radr,radd,r2,d2)
      CALL sla_DTP2S(-rads, rads,radr,radd,r3,d3)
      CALL sla_DTP2S( rads, rads,radr,radd,r4,d4)
      CALL sla_DTP2S(0.0D00,-rads,radr,radd,q,dmin)
      CALL sla_DTP2S(0.0D00, rads,radr,radd,q,dmax)
c
c...Compute RA Chunks
c
      rmin = MIN(r1,r2,r3,r4)
      rmax = MAX(r1,r2,r3,r4)
      IF ((rmax-rmin).le.pi) THEN
        nra = 1
        rfrst(1) = rmin*radian
        rlast(1) = rmax*radian
      ELSE
        rmin = 2.0D00*pi
        rmax = 0.0D00
        IF (r1.le.pi) THEN
          rmax = MAX(rmax,r1)
        ELSE
          rmin = MIN(rmin,r1)
        ENDIF
        IF (r2.le.pi) THEN
          rmax = MAX(rmax,r2)
        ELSE
          rmin = MIN(rmin,r2)
        ENDIF
        IF (r3.le.pi) THEN
          rmax = MAX(rmax,r3)
        ELSE
          rmin = MIN(rmin,r3)
        ENDIF
        IF (r4.le.pi) THEN
          rmax = MAX(rmax,r4)
        ELSE
          rmin = MIN(rmin,r4)
        ENDIF
        nra = 2
        rfrst(1) = 0.0D00
        rlast(1) = rmax*radian
        rfrst(2) = rmin*radian
        rlast(2) = 360.0D00
      ENDIF
c
c...Compute Dec Corners And Zones
c
      dmin = MIN(d1,d2,dmin)*radian
      dmax = MAX(d3,d4,dmax)*radian
      z1 = (dmin+90.0D00)/7.5D00
      z2 = (dmax+90.0D00)/7.5D00
      ndec = z2+1-z1
      j = 0
      DO i=z1,z2
        zmin =  i*7.5D00 - 90.0D00
        zmax = zmin+7.5D00
        j = j+1
        dzone(j) = i*75
        dfrst(j) = zmin
        dlast(j) = zmax
      ENDDO
      RETURN
      END
