      PROGRAM  calhist
c
c...Histogram Of Errors
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nhmax = 20
      INTEGER
     *         low, high, hist(NHMAX), i, nin, nout
      CHARACTER*64
     *         in, out
      REAL
     *         z
c
 9001 FORMAT (' Enter  Input File: ' $)
 9002 FORMAT (' Enter Output File: ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (10x, f5.0)
 9005 FORMAT (f10.2, i10)
c
c...Read The File
c
  100 WRITE (*,9001)
      READ  (*,9003) nin,in
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=100,
     *      form='formatted',
     *      name=in(1:nin),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 WRITE (*,9002)
      READ  (*,9003) nout,out
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name=out(1:nout),
     *      status='unknown',
     *      unit=2
     *     )
      DO i=1,NHMAX
        hist(i) = 0
      ENDDO
      low = 0
      high = 0
c
c...Do The Histogram
c
  120 READ (1,9004,end=130) z
      i = 10.0*z + 1.0
      IF (i.le.0) THEN
        low = low+1
      ELSEIF (i.gt.NHMAX) THEN
        high = high+1
      ELSE
        hist(i) = hist(i)+1
      ENDIF
      GO TO 120
  130 CLOSE (1)
      DO i=1,NHMAX
        z = (i-0.5)/10.0
        WRITE (2,9005) z,hist(i)
      ENDDO
      CLOSE (2)
      CALL EXIT
      END
