      PROGRAM  genmac
c
c...Generate Xplots Macro Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         np1 = 937,
     *         nmmax = 100
      REAL
     *         racoef(NP1), rbcoef(NP1), bacoef(NP1), bbcoef(NP1),
     *         a, b, rxmag(NMMAX,NP1), rymag(NMMAX,NP1), x, y, 
     *         bxmag(NMMAX,NP1), bymag(NMMAX,NP1)
      INTEGER
     *         i, id, rc(NP1), bc(NP1), nb(NP1), nr(NP1), nfn, j
      CHARACTER*64
     *         fn
c
 9001 FORMAT (15x, f9.0, 5x, f9.0, 32x, i4)
 9002 FORMAT (3x, 2f10.0, i5)
 9003 FORMAT (2f10.4)
 9004 FORMAT ('f', i3.3, '.b')
 9005 FORMAT ('XX')
 9006 FORMAT ('in f', i3.3, '.b 1 2')
 9007 FORMAT ('sg 12 20 12 20')
 9008 FORMAT ('uf 1 ', i3, ' 1', 2f10.6)
 9009 FORMAT ('pl')
 9010 FORMAT ('end')
 9011 FORMAT ('YY')
 9012 FORMAT ('in f', i3.3, '.r 1 2')
c
c...Initializations
c
  100 DO i=1,NP1
        bc(i) = 0
        rc(i) = 0
        nb(i) = 0
        nr(i) = 0
      ENDDO
c
c...Blue Coefficients
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='blue1.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) a,b,id
      bacoef(id) = a
      bbcoef(id) = b
      bc(id) = 1
      GO TO 110
  120 CLOSE (1)
c
c...Red Coefficients
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='red1.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9001,end=140) a,b,id
      racoef(id) = a
      rbcoef(id) = b
      rc(id) = 1
      GO TO 130
  140 CLOSE (1)
c
c...Blue Data
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='blue1.dat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  150 READ (1,9002,end=160) x,y,id
      nb(id) = nb(id)+1
      bxmag(nb(id),id) = x
      bymag(nb(id),id) = y
      GO TO 150
  160 CLOSE (1)
c
c...Red Data
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='red1.dat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  170 READ (1,9002,end=180) x,y,id
      nr(id) = nr(id)+1
      rxmag(nr(id),id) = x
      rymag(nr(id),id) = y
      GO TO 170
  180 CLOSE (1)
c
c...Generate Macros
c
      DO i=1,NP1
        IF  ((bc(i).gt.0).and.(rc(i).gt.0).and.(nb(i).gt.0)
     *  .and.(nr(i).gt.0)) THEN
          WRITE (fn,9004) i
          nfn = 6
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name=fn(1:nfn),
     *          status='unknown',
     *          unit=1
     *         )
          DO j=1,nb(i)
            WRITE (1,9003) bxmag(j,i),bymag(j,i)
          ENDDO
          CLOSE (1)
          fn(nfn:nfn) = 'r'
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name=fn(1:nfn),
     *          status='unknown',
     *          unit=1
     *         )
          DO j=1,nr(i)
            WRITE (1,9003) rxmag(j,i),rymag(j,i)
          ENDDO
          CLOSE (1)
          nfn = nfn-2
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name=fn(1:nfn),
     *          status='unknown',
     *          unit=1
     *         )
          WRITE (1,9005)
          WRITE (1,9006) i
          WRITE (1,9007)
          WRITE (1,9008) nb(i),bacoef(i),bbcoef(i)
          WRITE (1,9009)
          WRITE (1,9010)
          WRITE (1,9011)
          WRITE (1,9012) i
          WRITE (1,9007)
          WRITE (1,9008) nr(i),racoef(i),rbcoef(i)
          WRITE (1,9009)
          WRITE (1,9010)
          CLOSE (1)
        ENDIF
      ENDDO
c
c...All Done
c
      CALL EXIT
      END
