      SUBROUTINE  loadpri
c
c...Load The Primary Photometric Calibrators
c
      INCLUDE
     *            'parfit.inc'
      INTEGER
     *          nlb, i, j, k, n, jb, jr
      DOUBLE PRECISION
     *          cc(NCMAX), dd(NCMAX), ba, bb, ra, rb
      CHARACTER*64
     *          lb
c
 9001 FORMAT (' Cannot Open ', a)
 9003 FORMAT (' Field ', i4, ' Has ', i1, ' Calibrations')
 9004 FORMAT (i5, ' Primary Calibration Fields With ', i5,
     *        ' Multiple CCD Fields')
 9005 FORMAT (i4, 2i3, 30x, 10(1x,1pe11.4))
 9006 FORMAT ('calcoef.', i2.2)
 9007 FORMAT (' Loaded Coefficients From ', a)
 9008 FORMAT ('uncalcoef.', i2.2)
c
c...Ingest True Primary Calibration File
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='testc/gather.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NP1
        nbpoly(i) = 0
        nrpoly(i) = 0
      ENDDO
  110 READ (1,9005,end=120) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
      primary(i) = 1
      nbpoly(i) = jb
      DO k=1,jb
        bpoly(k,i) = cc(k)
      ENDDO
      nrpoly(i) = jr
      DO k=1,jr
        rpoly(k,i) = dd(k)
      ENDDO
      CALL reversion(nbpoly(i),bpoly(1,i))
      CALL reversion(nrpoly(i),rpoly(1,i))
      GO TO 110
  120 CLOSE (1)
c
c...Ingest Results Of Previous Solutions
c
      DO n=1,npass-1
        IF (noop.eq.0) THEN
          WRITE (lb,9006) n
          nlb = 10
        ELSE
          WRITE (lb,9008) n
          nlb = 12
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
  150   READ (1,9005,end=160) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
        primary(i) = 2
        nbpoly(i) = jb
        DO k=1,jb
          bpoly(k,i) = cc(k)
        ENDDO
        CALL reversion(nbpoly(i),bpoly(1,i))
        nrpoly(i) = jr
        DO k=1,jr
          rpoly(k,i) = dd(k)
        ENDDO
        CALL reversion(nrpoly(i),rpoly(1,i))
        GO TO 150
  160   CLOSE (1)
        WRITE (*,9007) lb(1:nlb)
      ENDDO
c
c...See If Everybody Has Been Fit
c
      alldone = 1
      DO i=1,NP1
        IF ((i.ne.723).and.(primary(i).eq.0)) THEN
          alldone = 0
          GO TO 170
        ENDIF
      ENDDO
  170 CONTINUE
      RETURN
c
c...Big Problem
c
  200 WRITE (*,9001) lb(1:nlb)
      CALL EXIT
      END
