      SUBROUTINE  bluehist
c
c...Histogram the blue arrays
c
      INCLUDE
     *            'apply.inc'
      PARAMETER
     *            nhist = 30
      INTEGER
     *            i, j, hist(NHIST)
      DOUBLE PRECISION
     *            sx(NHIST), sxx(NHIST), sy(NHIST), syy(NHIST), x, y
c
c...Fill The Histogram
c
  100 DO i=1,NHIST
        hist(i) = 0
        sx(i) = 0.0D00
        sxx(i) = 0.0D00
        sy(i) = 0.0D00
        syy(i) = 0.0D00
      ENDDO
      DO i=1,nblue
        j = ccdblue(i)
        IF ((j.ge.1).and.(j.le.NHIST)) THEN
          x = ccdblue(i)
          y = pmmblue(i)-ccdblue(i)
          sx(j) = sx(j) + x
          sxx(j) = sxx(j) + x*x
          sy(j) = sy(j) + y
          syy(j) = syy(j) + y*y
          hist(j) = hist(j) + 1
        ENDIF
      ENDDO
c
c...Simple Statistics
c
      DO i=1,NHIST
        IF (hist(i).eq.1) THEN
          sxx(i) = 0.0D00
          syy(i) = 0.0D00
        ELSEIF (hist(i).gt.1) THEN
          sx(i) = sx(i)/hist(i)
          sxx(i) = SQRT(sxx(i)/hist(i) - sx(i)*sx(i))
          sy(i) = sy(i)/hist(i)
          syy(i) = SQRT(syy(i)/hist(i) - sy(i)*sy(i))
        ENDIF
      ENDDO
      do i=1,nhist
      if (hist(i).ne.0) then
      write (*,9991) hist(i),sx(i),sxx(i),sy(i),syy(i)
      endif
      enddo
 9991 format (i10, 4f10.3)
      RETURN
      END
