      SUBROUTINE  bweight(nn,zz,ss,ww)
c
c...Weight According To Magnitude Bin
c
      INCLUDE
     *            'parfit.inc'
      PARAMETER
     *            factor = 5.0D00
      INTEGER
     *            nn, ss(*), hist(NP1), i, j
      DOUBLE PRECISION
     *            zz(*), ww(*), wbuf(NP1), x
c
c...Simple Override For Unit Weighting
c
  100 IF (unity.ne.0) THEN
        DO i=1,nn
          ww(i) = 1.0D00
        ENDDO
        RETURN
      ENDIF
c
c...Compute Number of Points Per Field
c
      DO i=1,NP1
        hist(i) = 0
      ENDDO
      DO i=1,nn
        j = ss(i)
        hist(j) = hist(j)+1
      ENDDO
c
c...Equal Weight Per Plate
c
      DO i=1,NP1
        IF (hist(i).le.0) THEN
          wbuf(i) = 0.0D00
        ELSE
          wbuf(i) = 1.0D00/hist(i)
        ENDIF
      ENDDO
c
c...Enhance CCD Standard Plates
c
      DO i=1,NP1
        IF (primary(i).eq.1) THEN
          wbuf(i) = FACTOR*wbuf(i)
        ENDIF
      ENDDO
c
c...Apply
c
      DO i=1,nn
        ww(i) = wbuf(ss(i))
      ENDDO
      RETURN
      END
