      PROGRAM  newspline
c
c...Fit Smoothing Spline
c
      INCLUDE
     *            'newfit.inc'
      INTEGER
     *            frst, last, i, j, k, ier, mode
      CHARACTER*1
     *            who
      DOUBLE PRECISION
     *            x, y, t
c
 9001 FORMAT (' CUBGVC Error=', i10)
 9002 FORMAT (i5, 2f10.4)
 9003 FORMAT (' Enter Color: ' $)
 9004 FORMAT (a)
 9005 FORMAT (f10.0, 20x, f10.0)
c
c...Copy And Fit Spline
c
  100 WRITE (*,9003)
      READ  (*,9004) who
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='newnodes.'//who,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nspl = 0
  110 READ (1,9005,end=120) x,y
      nspl = nspl+1
      splx(nspl) = x
      sply(nspl) = y-x
      yw(nspl) = 1.0D00
      IF (nspl.lt.NBMAX) GO TO 110
  120 CLOSE (1)
      yvar = -1.0D00
      CALL cubgcv(splx,sply,yw,nspl, yc,ycoef,NCODIM,
     *            yvar,1,se,wk,ier)
      IF (ier.ne.0) THEN
        WRITE (*,9001) ier
        CALL EXIT
      ENDIF
c
c...Generate Smoothed Relationship
c
      nsmooth = 0
      DO k=1,nspl-1
        DO j=1,100
          t = 0.01D00*(j-1)
          nsmooth = nsmooth+1
          xsmooth(nsmooth) = splx(k)+t
          ysmooth(nsmooth) = yc(k) + t*(ycoef(k,1)+t*(ycoef(k,2)
     *                     + t*ycoef(k,3)))
        ENDDO
      ENDDO
      nsmooth = nsmooth+1
      xsmooth(nsmooth) = splx(nspl)
      ysmooth(nsmooth) = yc(nspl)
c
c...Apply Unit Slope Correction And Save
c
      DO i=1,nsmooth
        ysmooth(i) = ysmooth(i)+xsmooth(i)
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='allsp.'//who,
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,nsmooth
        IF (xsmooth(i).lt.0.0D00) THEN
          j = 100.0D00*xsmooth(i)-0.5D00
        ELSE
          j = 100.0D00*xsmooth(i)+0.5D00
        ENDIF
        IF ((j.gt.0).and.(j.le.2500)) THEN
          WRITE (1,9002) j,xsmooth(i),ysmooth(i)
        ENDIF
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
