      SUBROUTINE  nspri
c
c...Load The Overlap Coefficients
c
      INCLUDE
     *            'nsfit.inc'
      DOUBLE PRECISION
     *          cc(NCMAX), dd(NCMAX)
      INTEGER
     *          i, k, jb, jr
c
 9001 FORMAT (i4, 2i3, 30x, 10(1x,1pe11.4))
 9002 FORMAT (' Transformation Not Loaded For Field ', i4)
c
c...North
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../binary/ugap7/calcoef.17',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
      IF ((i.lt.N_FIRST).or.(i.gt.N_LAST)) GO TO 110
      nbpoly(i) = jb
      DO k=1,jb
        bpoly(k,i) = cc(k)
      ENDDO
      nrpoly(i) = jr
      DO k=1,jr
        rpoly(k,i) = dd(k)
      ENDDO
      CALL reversion(nbpoly(i),bpoly(1,i))
      CALL reversion(nrpoly(i),rpoly(1,i))
      GO TO 110
  120 CLOSE (1)
c
c...South
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='soucoef.'//cpass,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  150 READ (1,9001,end=160) i,jb,jr,(cc(k),k=1,jb),(dd(k),k=1,jr)
      IF ((i.lt.S_FIRST).or.(i.gt.S_LAST)) GO TO 150
      nbpoly(i) = jb
      DO k=1,jb
        bpoly(k,i) = cc(k)
      ENDDO
      nrpoly(i) = jr
      DO k=1,jr
        rpoly(k,i) = dd(k)
      ENDDO
      CALL reversion(nbpoly(i),bpoly(1,i))
      CALL reversion(nrpoly(i),rpoly(1,i))
      GO TO 150
  160 CLOSE (1)
c
c...Sanity Check
c
      DO i=N_FIRST,N_LAST
        IF (nbpoly(i).eq.0) THEN
          WRITE (*,9002) i
          CALL EXIT
        ENDIF
      ENDDO
      DO i=S_FIRST,S_LAST
        IF (nbpoly(i).eq.0) THEN
          WRITE (*,9002) i
          CALL EXIT
        ENDIF
      ENDDO
      RETURN
      END
