      SUBROUTINE  nshist(nn,xx,yy,nh,hx,hy,hw,hp,gh)
c
c...Compute A Histogram And Follow The Ridge Line
c
      INCLUDE
     *            'nsfit.inc'
      INTEGER
     *            nn, ix, iy, i, numx, nh, gh(NYHIST,NXHIST),
     *            nxlow, nxhigh, nylow, nyhigh
      DOUBLE PRECISION
     *            xx(*), yy(*), hx(*), hy(*), hw(*), pp, ww, hp(*),
     *            nper(NXHIST), ntot
c
c...Initialization
c
  100 DO ix=1,NXHIST
        nper(ix) = 0.0D00
        DO iy=1,NYHIST
          hist(ix,iy) = 0
        ENDDO
      ENDDO
      nxlow = 0
      nxhigh = 0
      nylow = 0
      nyhigh = 0
c
c...Accumulation
c
      DO i=1,nn
        ix = (xx(i)-XLOW)/XWIDE + 1.0D00
        IF (ix.lt.1) THEN
          nxlow = nxlow+1
        ELSEIF (ix.gt.NXHIST) THEN
          nxhigh = nxhigh+1
        ELSE
          iy = (yy(i)-YLOW)/YWIDE + 1.0D00
          IF (iy.lt.1) THEN
            nylow = nylow+1
          ELSEIF (iy.gt.NYHIST) THEN
            nyhigh = nyhigh+1
          ELSE
            hist(iy,ix) = hist(iy,ix)+1
          ENDIF
        ENDIF
      ENDDO
c
c...Look For Peaks
c
      nh = 0
      ntot = 0.0D00
      DO ix=1,NXHIST
        numx = 0
        DO iy=1,NYHIST
          numx = numx + hist(iy,ix)
        ENDDO
        IF (numx.ge.NMIN) THEN
          CALL nspeak(NYHIST,hist(1,ix),pp,ww)
          nh = nh+1
          hx(nh) = (ix-0.5D00)*XWIDE + XLOW
          hy(nh) = (pp-1.0D00)*YWIDE + YLOW
          hw(nh) = ww*YWIDE
          nper(nh) = numx
          ntot = ntot+numx
        ENDIF
      ENDDO
      IF (ntot.gt.0.0D00) THEN
        DO ix=1,NXHIST
          hp(ix) = 100.0D00*nper(ix)/ntot
        ENDDO
      ENDIF
c
c...Save In Grand Histogram
c
      DO ix=1,NXHIST
        DO iy=1,NYHIST
          gh(iy,ix) = gh(iy,ix)+hist(iy,ix)
        ENDDO
      ENDDO
      RETURN
      END
