      SUBROUTINE  iterate
c
c...Quick Iteration To Find Pairs
c
      INCLUDE
     *            'p1p2.inc'
      PARAMETER
     *            nitmax = 10,
     *            arcsec = 1.33D00
      INTEGER
     *            niter, npold, i, err
c
 9001 FORMAT (' Iter=', i2, '  NPair=', i6, '  SX=', f6.4, '  SY=',
     *        f6.4)
 9002 FORMAT (i2, ')', 2(1x,1pe15.8,'+/-',1pe9.3))
c
c...Initialize
c
  100 niter = 0
      radius = ARCSEC/TELSCALE
      ncoef = 1
      DO i=1,ncoef
        xcoef(i) = 0.0D00
        ycoef(i) = 0.0D00
      ENDDO
      xcoef(2) = 1.0D00
      ycoef(3) = 1.0D00
c
c...Iterate
c
  110 niter = niter+1
      CALL xform
      CALL pairfind
      IF (ncoef.eq.1) THEN
        CALL p1fit
      ELSE
        CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
        IF (err.ne.0) GO TO 200
        CALL pairfit(y1, ycoef,sycoef,sigmay, err)
        IF (err.ne.0) GO TO 200
      ENDIF
      WRITE (*,9001) niter,npair,sigmax,sigmay
      DO i=1,ncoef
        WRITE (*,9002) i,xcoef(i),sxcoef(i),ycoef(i),sycoef(i)
      ENDDO
      IF (niter.eq.1) THEN
        npold = npair
        GO TO 110
      ELSE
        IF ((npair.ne.npold).and.(niter.lt.NITMAX)) THEN
          npold = npair
          GO TO 110
        ENDIF
      ENDIF
      RETURN
c
c...Big Problem
c
  200 CALL EXIT
      END
