      PROGRAM  parfit
c
c...Fit PCALIB Files
c
      INCLUDE
     *         'parfit.inc'
      PARAMETER
     *         nmin = 50
      INTEGER
     *         id, num, nfn, i, C_GENLEN, nd, np, ns, npp
      CHARACTER*64
     *         fn
      BYTE
     *         bb(65)
c
 9001 FORMAT (i4, i10, 1x, q, a)
 9002 FORMAT (' Cannot Open ', a)
 9003 FORMAT (' Too Many Stars ', i10, 1x, a)
 9004 FORMAT (i4, 2i3, 2(1x,f4.2), 2i8, 2i2, 10(1x,1pe11.4))
 9005 FORMAT (' Too Few Stars ', i10, 1x, a)
 9006 FORMAT (' Fatal Error Reading ', 2i10, 1x, a)
 9007 FORMAT (' File Length Error ', 2i12, 1x, a)
 9008 FORMAT (' N(pri)=', i4, '  N(sec)=', i4, '  N(p+p)=', i4,
     *        '  N(calib)=', i4)
 9009 FORMAT (i2.2)
c
c...Global Initialization
c
  100 CALL pass(npass)
      WRITE (cpass,9009) npass
      CALL loadpri
      DO i=1,NP1
        IF (primary(i).eq.0) THEN
          status(i) = 0
        ELSE
          status(i) = 1
        ENDIF
      ENDDO
      nbcoef = 2
      nrcoef = 2
      noop = 0
      unity = 1
c
c...Open Input And Summary Files
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='callist.'//cpass,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=3
     *     )
      IF (noop.eq.0) THEN
        fn = 'calcoef.'//cpass
        nfn = 8+LEN(cpass)
      ELSE
        fn = 'uncalcoef.'//cpass
        nfn = 10+LEN(cpass)
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=fn(1:nfn),
     *      status='unknown',
     *      unit=4
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='calerr.'//cpass,
     *      status='unknown',
     *      unit=9
     *     )
c
c...Process Each File
c
  110 READ (3,9001,end=300) id,num,nfn,fn
      IF (num.gt.NMAX) THEN
        WRITE (9,9003) num,fn(1:nfn)
        GO TO 110
      ENDIF
      IF (num.lt.NMIN) THEN
        WRITE (9,9005) num,fn(1:nfn)
        GO TO 110
      ENDIF
      DO i=1,nfn
        bb(i) = ICHAR(fn(i:i))
      ENDDO
      bb(nfn+1) = 0
      nd = C_GENLEN(bb)
      IF ((MOD(nd,8).ne.0).or.((nd/8).ne.num)) THEN
        WRITE (9,9007) nd,num,fn(1:nfn)
        GO TO 110
      ENDIF
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=fn(1:nfn),
     *      readonly,
     *      recl=2*num,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1,err=210) (vec(i),i=1,2*num)
      CLOSE (1)
      CALL fitloop(id,num)
      WRITE (4,9004) id,nbcoef,nrcoef,sigmab,sigmar,nb,nr,nptmp,nstmp,
     *               (bcoef(i),i=1,nbcoef),
     *               (rcoef(i),i=1,nrcoef)
      status(id) = status(id)+2
      GO TO 110
c
c...Some Kind Of Trouble
c
  200 WRITE (9,9002) fn(1:nfn)
      GO TO 110
  210 WRITE (9,9006) id,num,fn(1:nfn)
      CLOSE (1)
      GO TO 110
c
c...All Done
c
  300 CLOSE (3)
      CLOSE (4)
      np = 0
      ns = 0
      npp = 0
      DO i=1,NP1
        IF (i.ne.723) THEN
          IF (status(i).eq.1) THEN
            np = np+1
          ELSEIF (status(i).eq.2) THEN
            ns = ns+1
          ELSEIF (status(i).eq.3) THEN
            npp = npp+1
          ENDIF
        ENDIF
      ENDDO
      i = np+ns+npp
      WRITE (9,9008) np,ns,npp,i
      CLOSE (9)
      CALL EXIT
      END
