      PROGRAM  npmread
c
c...Parse And Process NPM1
c
      IMPLICIT
     *          NONE
      PARAMETER
     *          nmax = 148940
      INTEGER
     *          npmid(NMAX), ra10mas(NMAX), dec10mas(NMAX), i, nlb,
     *          zdd, zid, b10mmag(NMAX), v10mmag(NMAX), id, idx(NMAX),
     *          tmp(NMAX)
      DOUBLE PRECISION
     *          rhh, rmm, rss, ddd, dmm, dss, pmra, pmdec, bmag,
     *          bmv, vmag, radian, rv, pi, xxra, xxdec, yy, zz,
     *          r2000, d2000, convert, r1950, d1950, equator, mult
      CHARACTER*132
     *          lb
      CHARACTER*1
     *          zs, ds
c
 9001 FORMAT (a,i2,1x,i4, 1x,f2.0,1x,f2.0,1x,f6.0,
     * 1x,a,f2.0,1x,f2.0,1x,f5.0, 2f8.0, 2f6.0)
 9002 FORMAT (q, a)
 9003 FORMAT (' Mult=', f4.1)
c
c...Open The Catalog
c
  100 OPEN (
     *       access='sequential',
     *       carriagecontrol='list',
     *       dispose='keep',
     *       form='formatted',
     *       name='/uz6/xpmm/sg5/tycho/a1199_npm1.dat',
     *       readonly,
     *       shared,
     *       status='old',
     *       unit=1
     *      )
      radian = 45.0D00/ATAN(1.0D00)
      convert = radian*3600.0D00*100.0D00
      equator = 90.0D00*3600.0D00*100.0D00
      mult = 0.1D00
      WRITE (*,9003) mult
c
c...Read And Parse
c
      DO i=1,NMAX
        READ (1,9002) nlb,lb
        READ (lb(1:nlb),9001) zs,zdd,zid, rhh,rmm,rss, ds,ddd,dmm,dss,
     *                pmra,pmdec, bmag,bmv
        r1950 = rhh + rmm/60.0D00 + rss/3600.0D00
        d1950 = ddd + dmm/60.0D00 + dss/3600.0D00
        IF (ds.eq.'-') THEN
          d1950 = -d1950
        ENDIF
        id = zdd*10000 + zid
        IF (zs.eq.'-') THEN
          id = -id
        ENDIF
        IF (bmv.ge.-9.0D00) THEN
          vmag = bmag-bmv
        ELSE
          vmag = -9.99D00
        ENDIF
c
c...Precess
c
        r1950 = (15.0D00*r1950)/radian
        d1950 = d1950/radian
        pmra = pmra/(100.0D00*3600.0D00*radian*COS(d1950))
        pmdec = pmdec/(100.0D00*3600.0D00*radian)
c
c...Cheat.  Multiply By MULT To Approximate Coordinates At Survey Epoch
c
        pmra = pmra*mult
        pmdec = pmdec*mult
        pi = 0.0D00
        rv = 0.0D00
        CALL sla_FK425(r1950,d1950, pmra,pmdec, pi,rv,
     *                 r2000,d2000, xxra,xxdec, yy,zz)
c
c...Convert To PseudoTycho Units And Save
c
        ra10mas(i) = r2000*convert
        dec10mas(i) = d2000*convert + equator
        b10mmag(i) = bmag*100.0D00
        v10mmag(i) = vmag*100.0D00
        npmid(i) = id
      ENDDO
      CLOSE (1)
c
c...Sort On R2000
c
      DO i=1,NMAX
        idx(i) = i
      ENDDO
      CALL iuqsrt(NMAX,ra10mas,idx)
      CALL ireord(NMAX,idx,dec10mas,tmp)
      CALL ireord(NMAX,idx,b10mmag,tmp)
      CALL ireord(NMAX,idx,v10mmag,tmp)
      CALL ireord(NMAX,idx,npmid,tmp)
c
c...Open And Save As A Direct Access File
c
      OPEN (
     *       access='direct',
     *       carriagecontrol='none',
     *       convert='big_endian',
     *       dispose='keep',
     *       form='unformatted',
     *       name='/uz6/xpmm/sg5/tycho/npm1.srt',
     *       recl=NMAX,
     *       recordtype='fixed',
     *       status='unknown',
     *       unit=2
     *      )
      WRITE (2,rec=1) (ra10mas(i),i=1,NMAX)
      WRITE (2,rec=2) (dec10mas(i),i=1,NMAX)
      WRITE (2,rec=3) (b10mmag(i),i=1,NMAX)
      WRITE (2,rec=4) (v10mmag(i),i=1,NMAX)
      WRITE (2,rec=5) (npmid(i),i=1,NMAX)
      CLOSE (2)
      CALL EXIT
      END
