      PROGRAM  tychosort
c
c...Sort Binary Version Of TYCHO, And Invert Storage For Faster Acces
c
c
      IMPLICIT
     *          NONE
      PARAMETER
     *          nmax = 1049971
      INTEGER
     *          ticid1(NMAX), ticid2(NMAX), ra10mas(NMAX),
     *          spd10mas(NMAX), e_pos10mas(NMAX), e_b10mmag(NMAX),
     *          b10mmag(NMAX), e_v10mmag(NMAX), v10mmag(NMAX),
     *          flags(NMAX), index(NMAX), tmp(NMAX)
      INTEGER
     *          i
c
c...Open The Catalog
c
  100 OPEN (
     *       access='direct',
     *       carriagecontrol='none',
     *       convert='big_endian',
     *       dispose='keep',
     *       form='unformatted',
     *       name='tycho.bin',
     *       readonly,
     *       recl=10,
     *       recordtype='fixed',
     *       shared,
     *       status='old',
     *       unit=1
     *      )
      DO i=1,NMAX
        READ (1,rec=i) ticid1(i),ticid2(i),ra10mas(i),spd10mas(i),
     *                  e_pos10mas(i),e_b10mmag(i),b10mmag(i),
     *                  e_v10mmag(i),v10mmag(i),flags(i)
        index(i) = i
      ENDDO
      CLOSE (1)
c
c...Sort And ReOrder
c
      CALL iuqsrt(NMAX,ra10mas,index)
      CALL ireord(NMAX,index,ticid1    ,tmp)
      CALL ireord(NMAX,index,ticid2    ,tmp)
      CALL ireord(NMAX,index,spd10mas  ,tmp)
      CALL ireord(NMAX,index,e_pos10mas,tmp)
      CALL ireord(NMAX,index,e_b10mmag ,tmp)
      CALL ireord(NMAX,index,b10mmag   ,tmp)
      CALL ireord(NMAX,index,e_v10mmag ,tmp)
      CALL ireord(NMAX,index,v10mmag   ,tmp)
      CALL ireord(NMAX,index,flags     ,tmp)
c
c...Save By Vector
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='tycho.srt',
     *      recl=NMAX,
     *      recordtype='fixed',
     *      status='unknown',
     *      unit=2
     *     )
      WRITE (2,rec= 1) ticid1
      WRITE (2,rec= 2) ticid2
      WRITE (2,rec= 3) ra10mas
      WRITE (2,rec= 4) spd10mas
      WRITE (2,rec= 5) e_pos10mas
      WRITE (2,rec= 6) e_b10mmag
      WRITE (2,rec= 7) b10mmag
      WRITE (2,rec= 8) e_v10mmag
      WRITE (2,rec= 9) v10mmag
      WRITE (2,rec=10) flags
      CLOSE (2)
      CALL EXIT
      END
