      SUBROUTINE  rweight(nn,zz,ww)
c
c...Weight According To Magnitude Bin
c
      INCLUDE
     *            'parfit.inc'
      PARAMETER
     *            bright = 13,
     *            faint = 20
      INTEGER
     *            nn, hist(FAINT), i, j, nbrt, nfnt
      DOUBLE PRECISION
     *            zz(*), ww(*), wbuf(FAINT), wb, wf, x, w
c
c
c...Compute Histogram
c
  100 IF (unity.ne.0) THEN
        DO i=1,nn
          ww(i) = 1.0D00
        ENDDO
        RETURN
      ENDIF
      nbrt = 0
      nfnt = 0
      DO i=BRIGHT,FAINT
        hist(i) = 0
      ENDDO
      DO i=1,nn
        j = zz(i)+MBAR
        IF (j.lt.BRIGHT) THEN
          nbrt = nbrt+1
        ELSEIF (j.gt.FAINT) THEN
          nfnt = nfnt+1
        ELSE
          hist(j) = hist(j)+1
        ENDIF
      ENDDO
c
c...Compute Weights So That N Is Conserved
c
      x = 0.0D00
      IF (nbrt.gt.0) THEN
        x = x+0.5D00
      ENDIF
      IF (nfnt.gt.0) THEN
        x = x+0.5D00
      ENDIF
      DO i=BRIGHT,FAINT
        IF (hist(i).gt.0) THEN
          x = x+1.0D00
        ENDIF
      ENDDO
      w = nn/x
      IF (nbrt.gt.0) THEN
        wb = 0.5*w/nbrt
      ELSE
        wb = 0.0
      ENDIF
      IF (nfnt.gt.0) THEN
        wf = 0.5*w/nfnt
      ELSE
        wf = 0.0
      ENDIF
      DO i=BRIGHT,FAINT
        IF (hist(i).gt.0) THEN
          wbuf(i) = w/hist(i)
        ELSE
          wbuf(i) = 0.0
        ENDIF
      ENDDO
      DO i=1,nn
        j = zz(i)+MBAR
        IF (j.lt.BRIGHT) THEN
          ww(i) = wb
        ELSEIF (j.gt.FAINT) THEN
          ww(i) = wf
        ELSE
          ww(i) = wbuf(j)
        ENDIF
      ENDDO
      RETURN
      END
