      PROGRAM  phxanal
c
c...Process PHX Files
c
      INCLUDE
     *         'phxanal.inc'
      PARAMETER
     *         nhist = 80,
     *         histmin = -5.0D00,
     *         histstep = 0.1D00,
     *         nmax = 1037,
     *         toofew = 9
      INTEGER
     *         i, j, err, hist(NHIST), nlow, nhigh, nlb
      DOUBLE PRECISION
     *         tycho, pmm, zp, x, y, f(NMAX),
     *         histcent(NHIST)
      CHARACTER*64
     *         lb
c
 9001 FORMAT (i4, 3f10.2, 2i5, f5.1)
 9002 FORMAT (' Cannot Process ', a, i4.4)
 9003 FORMAT (f6.2, i10)
 9004 FORMAT (i3, 5x, i4)
 9005 FORMAT (' ID=', i4, '  ZP=', f10.2)
 9006 FORMAT (' ID=', i4, '  ZP=', f10.2, '   Fract=', f4.1)
 9007 FORMAT (' N(hist)=', i4)
c
c...Initialization
c
  100 survey = 'so'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=survey//'.ok',
     *      status='unknown',
     *      unit=2
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=survey//'.no',
     *      status='unknown',
     *      unit=3
     *     )
      DO i=1,NHIST
        hist(i) = 0
        histcent(i) = HISTMIN + (i-1)*HISTSTEP + HISTSTEP/2.0D00
      ENDDO
      nlow = 0
      nhigh = 0
c
c...Load The MAG Fraction
c
      IF (survey.eq.'so') THEN
        lb = '../autotycho/to.mag'
        nlb = 19
      ELSEIF (survey.eq.'se') THEN
        lb = '../autotycho/te.mag'
        nlb = 19
      ELSE
        STOP 'MAG File'
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NMAX
        f(i) = 0.0D00
      ENDDO
  110 READ (1,9004,end=120) i,j
      f(i) = 0.1D00*j
      GO TO 110
  120 CLOSE (1)
c
c...Process
c
      DO i=1,937
        id = i
        CALL phxread(err)
        IF (err.eq.0) THEN
          IF (nmcoef.eq.1) THEN
            zp = 0.01D00*mcoef(1)
            mcoef(2) = 0.0D00
          ELSEIF (nmcoef.eq.2) THEN
            tycho = 1100.0D00
            pmm = (tycho-mcoef(1))/mcoef(2)
            zp = 0.01D00*(tycho-pmm)
          ELSE
            STOP 'NMCOEF'
          ENDIF
          IF (nin.le.TOOFEW) THEN
            WRITE (3,9001) i,zp,mcoef(1),mcoef(2),nin,npair,f(id)
          ELSE
            WRITE (2,9001) i,zp,mcoef(1),mcoef(2),nin,npair,f(id)
            IF (f(id).ge.25.0D00) THEN
              j = (zp-HISTMIN)/HISTSTEP + 1.0D00
              IF (j.lt.1) THEN
                WRITE (*,9005) id,zp
              ELSEIF (j.gt.NHIST) THEN
                WRITE (*,9005) id,zp
              ELSE
                hist(j) = hist(j)+1
              ENDIF
            ELSE
              WRITE (*,9006) id,zp,f(id)
            ENDIF
          ENDIF
        ELSE
          WRITE (*,9002) survey,id
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Save Histogram
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='phxhist.'//survey,
     *      status='unknown',
     *      unit=2
     *     )
      DO i=1,NHIST
        WRITE (2,9003) histcent(i),hist(i)
      ENDDO
      CLOSE (2)
      j = 0
      DO i=1,NHIST
        j = j+hist(i)
      ENDDO
      WRITE (*,9007) j
      CALL EXIT
      END
