      PROGRAM  phxbar
c
c...Solve For ZeroPoints
c
      INCLUDE
     *            'phxbar.inc'
      INTEGER
     *            nroot, nlb, i, n, jd, id, err, f, fmax, sn
      DOUBLE PRECISION
     *            cm, pm, sx, sy, syy, y
      CHARACTER*64
     *            root, lb
      CHARACTER*2
     *            prefix
      CHARACTER*1
     *            c
c
 9001 FORMAT (a, a, '/', a, i4.4, '.fit')
 9002 FORMAT (2x, i10)
 9003 FORMAT (2i5, 7f10.5)
 9004 FORMAT (' Too Many Points', 2i10)
c
c...Initialization
c
  100 CALL f_doenv('AUXTYC:auxtyc',nroot,root)
      mode = 1
      IF (mode.eq.1) THEN
        fmax = 937
      ELSEIF (mode.eq.2) THEN
        fmax = 1037
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='phxbar.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO f=1,fmax
c
c...Read FIT File
c
        IF (mode.eq.1) THEN
          prefix = 'to'
          i = f/100
          c = CHAR(ICHAR('0')+i)
        ELSEIF (mode.eq.2) THEN
          prefix = 'te'
          i = f/100
          IF (i.le.9) THEN
            c = CHAR(ICHAR('0')+i)
          ELSE
            c = 'z'
          ENDIF
        ELSE
          STOP 'MODE In PHXBAR'
        ENDIF
        WRITE (lb,9001) root(1:nroot),c,prefix,f
        nlb = 12+nroot
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,9002)
        READ (2,9002)
        READ (2,9002) n
        CLOSE (2)
        IF (n.gt.NMAX) THEN
          WRITE (*,9004) n,NMAX
          CALL EXIT
        ENDIF
c
c...Ingest The RES File
c
        lb(nlb-2:nlb) = 'res'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=n,
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,rec=5) (pmmmag(i),i=1,n)
        READ (2,rec=6) (catmag(i),i=1,n)
        CLOSE (2)
c
c...Do The Fit
c
        nc = 1
        nn = 0
        DO i=1,n
          IF (catmag(i).gt.0) THEN
            cm = 0.01D00*catmag(i)
            pm = 0.01D00*pmmmag(i)
            CALL phxsane(cm,pm,err)
            IF (err.eq.0) THEN
              nn = nn+1
              xx(nn) = cm
              yy(nn) = pm
            ENDIF
          ENDIF
        ENDDO
        IF (nn.ge.(nc+2)) THEN
          CALL phxfit
        ELSE
          DO i=1,nc
            cc(i) = 0.0D00
            ss(i) = 0.0D00
          ENDDO
          sg = -1.0D00
        ENDIF
c
c...All Done
c
        WRITE (1,9003) f,nn,(cc(i),i=1,nc),sg,(ss(i),i=1,nc)
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
