      PROGRAM  reacc
c
c...Check The ACC Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nzone = 96,
     *         nchunk = 1*1000*1000
      INTEGER
     *         nlb, i, frst(NZONE), long(NZONE), n, nloop, nmost,
     *         nlast, buf(3,NCHUNK), fd, err, C_ROOPEN, C_READER, t,
     *         j, k, total, test(NZONE+1), m, zone
      CHARACTER*80
     *         lb
      BYTE
     *         bb(81)
c
 9001 FORMAT (5x, 2i12)
 9002 FORMAT (' FD=', i1, '  >>', a, '<<')
 9003 FORMAT (' T=', i2, '  Obs=', i12, '   ACC=', i12, ' Err=', i12)
 9004 FORMAT ('/uv6/xpmm/zone/zone', i4.4, '.acc')
 9005 FORMAT (' Checking ', a)
c
c...Eat The ACC File
c
  100 DO zone=1725,0,-75
      WRITE (lb,9004) zone
      nlb = 27
      WRITE (*,9005) lb(1:nlb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NZONE
        READ (1,9001) frst(i),long(i)
      ENDDO
      CLOSE (1)
c
c...Compute The Test Values
c
      DO i=1,NZONE+1
        test(i) = i*0.25*15.0D00*3600.0D00*100.0D00 + 0.5D00
      ENDDO
c
c...Compute The Parameters Of The CHUNK Reads
c
      n = frst(NZONE) + long(NZONE) - 1
      nloop = ((n-1)/NCHUNK) + 1
      nmost = NCHUNK
      nlast = n - (nloop-1)*NCHUNK
      t = 1
      lb(nlb-2:nlb) = 'cat'
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      fd = C_ROOPEN(bb)
      WRITE (*,9002) fd,lb(1:nlb)
      IF (fd.lt.3) THEN
        CALL EXIT
      ENDIF
      total = 0
c
c...Do The Loop
c
      DO i=1,nloop
        IF (i.eq.nloop) THEN
          m = nlast
        ELSE
          m = nmost
        ENDIF
        err = C_READER(fd,buf,12*m)
        DO j=1,m
          IF (buf(1,j).ge.test(t)) THEN
            k = total+j
            err = k-frst(t+1)
            IF (err.ne.0) THEN
              WRITE (*,9003) t,k,frst(t+1),err
            ENDIF
            t = t+1
            IF (t.ge.NZONE) GO TO 110
          ENDIF
        ENDDO
        total = total+m
      ENDDO
      CALL c_closer(fd)
  110 CONTINUE
      ENDDO
      CALL EXIT
      END
