      SUBROUTINE  bunpack
c
c...Unpack The Various Blue Variables
c
      INCLUDE
     *            'usexid.inc'
      PARAMETER
     *            mag_err = 1,
     *            amp_err = 2,
     *            r0_err = 4,
     *            m00_err = 8,
     *            pcnt_err = 16
      INTEGER
     *            i, err, u, nlb, source
      REAL
     *            x, y, s, c
      CHARACTER*64
     *            lb
c
 9001 FORMAT (i5, 5f8.2, 8f7.2, 3i8)
c
c...BUF Contains (4) = IDST
c
  100 DO i=1,nk
        pbmag(i) = 0.01*bbuf(kbidx(i))
        IF (pbmag(i).ge.25.0) THEN
          pberr(i) = MAG_ERR
        ELSE
          pberr(i) = 0
        ENDIF
      ENDDO
c
c...Process (1) = IAST
c
      CALL p1xid(field,'so',1,nb,bbuf,err)
      DO i=1,nk
        CALL xiast(bbuf(kbidx(i)),pbamp(i),pbm00(i))
        IF ((pbamp(i).le.225.0).and.(pbmag(i).le.18.0)) THEN
          pberr(i) = IOR(pberr(i),AMP_ERR)
        ENDIF
      ENDDO
c
c...Process (2) = IBST
c
      CALL p1xid(field,'so',2,nb,bbuf,err)
      DO i=1,nk
        CALL xibst(bbuf(kbidx(i)),pbsig(i),pbr0(i))
        IF (pbr0(i).ge.700.0) THEN
          pberr(i) = IOR(pberr(i),R0_ERR)
        ENDIF
      ENDDO
c
c...Process (3) = ICST
c
      CALL p1xid(field,'so',3,nb,bbuf,err)
      DO i=1,nk
        CALL xicst(bbuf(kbidx(i)),pbm00(i))
        IF (pbm00(i).le.0.0) THEN
          pberr(i) = IOR(pberr(i),M00_ERR)
        ENDIF
      ENDDO
c
c...Process (5) = IEST
c
      CALL p1xid(field,'so',5,nb,bbuf,err)
      DO i=1,nk
        CALL xiest(bbuf(kbidx(i)),pbdiag(i))
      ENDDO
c
c...Process (8) = ITST
c
      CALL p1xid(field,'so',8,nb,bbuf,err)
      DO i=1,nk
        CALL xitst(bbuf(kbidx(i)),pbnin(i),pbnsat(i))
      ENDDO
c
c...Process (9)+(10) = IXST+IYST
c
      CALL p1xid(field,'so',9,nb,bbuf,err)
      DO i=1,nk
        CALL xixst(bbuf(kbidx(i)),pbrad(i))
      ENDDO
      CALL p1xid(field,'so',10,nb,bbuf,err)
      DO i=1,nk
        CALL xiyst(bbuf(kbidx(i)),pbrad(i))
      ENDDO
c
c...Do The Integral
c
      DO i=1,nk
        s = pbsig(i)*pbsig(i)
        x = -pbr0(i)/s
        y = EXP(x)
        pbint(i) = -3.14*s*pbamp(i)*LOG(y/(y+1.0))
      ENDDO
c
c...Take LOG Of Various Things
c
      DO i=1,nk
        CALL xidrlog(pbr0(i),pbr0(i))
        CALL xidrlog(pbm00(i),pbm00(i))
        CALL xidrlog(pbdiag(i),pbdiag(i))
        CALL xidrlog(pbint(i),pbint(i))
        CALL intmag(pbint(i))
        CALL xidilog(pbnin(i),pblnin(i))
        CALL xidilog(pbnsat(i),pblnsat(i))
        x = pbnsat(i)
        y = MAX(pbnin(i),1)
        pbpcnt(i) = 100.0*x/y
        IF (pbpcnt(i).ge.45.0) THEN
          pberr(i) = IOR(pberr(i),PCNT_ERR)
        ENDIF
      ENDDO
c
c...Split According To Error
c
      CALL f_doenv('PIPROG:'//sname(1:nsname)//'.bok',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      lb(nlb-2:nlb) = 'ber'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=2
     *     )
      DO i=1,nk
        IF (pberr(i).eq.0) THEN
          u = 1
        ELSE
          u = 2
        ENDIF
        c = kbmag(i)-krmag(i)
        IF (i.le.nfrompi) THEN
          source = 1
        ELSE
          source = 2
        ENDIF
        WRITE (u,9001) i,kbmag(i),pbmag(i),c,pbamp(i),pbsig(i),
     *                 pbr0(i),pbm00(i),pbdiag(i),pbrad(i),pblnin(i),
     *                 pblnsat(i),pbpcnt(i),pbint(i),pberr(i),source,
     *                 field
      ENDDO
      CLOSE (1)
      CLOSE (2)
      RETURN
      END
