      SUBROUTINE  tycxid
c
c...Read O and E Tycho Files
c
      INCLUDE
     *            'usexid.inc'
      INTEGER
     *            nroot, nlb, mode, i, i1, i2, mtb, mtr, mpb, mpr,
     *            jo, je, j
      CHARACTER*64
     *            root, lb
      CHARACTER*2
     *            prefix(2)
      CHARACTER*1
     *            c
      DATA
     *            prefix/'to', 'te'/
c
 9001 FORMAT (a, a, '/', a, i4.4, '.fit')
 9002 FORMAT (2x, i10)
 9003 FORMAT (2i5, 7f10.5)
 9004 FORMAT (' Too Many Points', 2i10)
 9005 FORMAT (' NTy=', i4, '  Nerr=', i4)
c
c...Initialization
c
  100 CALL f_doenv('AUXTYC:auxtyc',nroot,root)
      DO mode=1,2
        i = field/100
        c = CHAR(ICHAR('0')+i)
        WRITE (lb,9001) root(1:nroot),c,prefix(mode),field
        nlb = 12+nroot
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,9002)
        READ (2,9002)
        READ (2,9002) ntycho(mode)
        CLOSE (2)
        IF (ntycho(mode).gt.NTYMAX) THEN
          WRITE (*,9004) ntycho(mode),NMAX
          CALL EXIT
        ENDIF
c
c...Ingest The RES File
c
        lb(nlb-2:nlb) = 'res'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=ntycho(mode),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,rec=5) (typmag(i,mode),i=1,ntycho(mode))
        READ (2,rec=6) (tytmag(i,mode),i=1,ntycho(mode))
        READ (2,rec=7) (tytid(i,mode),i=1,ntycho(mode))
        READ (2,rec=8) (typid(i,mode),i=1,ntycho(mode))
        CLOSE (2)
      write (*,9991) mode,ntycho(mode),lb(1:nlb)
 9991 format (2i10, ' >>', a, '<<')
c
c...Sort On Tycho INDEX
c
        DO i=1,ntycho(mode)
          idx(i) = i
        ENDDO
        CALL iuqsrt(ntycho(mode),tytid(1,mode),idx)
        CALL ireord(ntycho(mode),idx,typid(1,mode),tmp)
        CALL ireord(ntycho(mode),idx,typmag(1,mode),tmp)
        CALL ireord(ntycho(mode),idx,tytmag(1,mode),tmp)
      ENDDO
c
c...Look For Unique Pairs
c
      ntypair = 0
      i1 = 0
      i2 = 1
  110 i1 = i1+1
      IF (i1.le.ntycho(1)) THEN
  120   IF (tytid(i2,2).lt.tytid(i1,1)) THEN
          IF (i2.ge.ntycho(2)) THEN
            GO TO 130
          ENDIF
          i2 = i2+1
          GO TO 120
        ELSEIF (tytid(i2,2).eq.tytid(i1,1)) THEN
          ntypair = ntypair+1
          ty1pair(ntypair) = i1
          ty2pair(ntypair) = i2
        if (tytid(i2+1,2).eq.tytid(i1,1)) then
      write (*,9995) i1,tytid(i1,1),i2,tytid(i2,2),i2+1,tytid(i2+1,2)
      pause
      endif
 9995 format (' Ooops', 6i10)
        ENDIF
        GO TO 110
      ENDIF
  130 CONTINUE
c
c...Sanity Check
c
      j = 0
      DO i=1,ntypair
        i1 = ty1pair(i)
        i2 = ty2pair(i)
        mtb = tytmag(i1,1)
        mtr = tytmag(i2,2)
        mpb = typmag(i1,1)
        mpr = typmag(i2,2)
        jo = typid(i1,1)
        je = typid(i2,2)
        IF ((mpb.ne.bbuf(jo)).or.(mpr.ne.rbuf(je))) THEN
          j = j+1
      write (*,9994) tytid(i1,1),tytid(i2,2)
 9994 format (2i12)
      write (*,9993) j,mtb,mtr,mpb,mpr,jo,je,bbuf(jo),rbuf(je)
 9993 format (9i8)
      if (mod(j,10).eq.0) pause
        ENDIF
      ENDDO
      WRITE (*,9005) ntypair,j
      RETURN
      END
