      SUBROUTINE  jfload(err)
c
c...Load J and F Pairs
c
      INCLUDE
     *            'sdss.inc'
      INTEGER
     *            err, nlb, ntb, i, j
      CHARACTER*64
     *            lb, tb
c
 9001 FORMAT ('AUXJF:kf', i4.4, '.fit')
 9002 FORMAT ('AUXJF:jf', i4.4, '.fit')
 9003 FORMAT (' Cannot Find AUXJF File For Field ', i3)
 9004 FORMAT (i2, i10)
 9005 FORMAT (2x, 2(1x,e15.8))
 9006 FORMAT (' Too Many Pairs', 2i12)
 9007 FORMAT (' Field=', i3, '   N(JFPairs)=', i10)
c
c...Try To Load The AUXJF File
c
  100 DO i=1,2
        IF (i.eq.1) THEN
          WRITE (lb,9001) oldzone
          dotaff = 1
        ELSE
          WRITE (lb,9002) oldzone
          dotaff = 0
        ENDIF
        nlb = 16
        CALL f_doenv(lb(1:nlb),ntb,tb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=110,
     *        form='formatted',
     *        name=tb(1:ntb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        GO TO 120
  110   CONTINUE
      ENDDO
      WRITE (*,9003) oldzone
      err = -2
      RETURN
  120 READ (1,9004)
      READ (1,9004)
      READ (1,9004) njfcoef,njfpair
      DO i=1,njfcoef
        READ (1,9005) jfxcoef(i),jfycoef(i)
      ENDDO
      CLOSE (1)
      IF (njfpair.gt.NMAX) THEN
        WRITE (*,9006) njfpair,NPMAX
        err = -3
        RETURN
      ENDIF
c
c...Load The Pairs
c
      tb(ntb-2:ntb) = 'par'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=njfpair,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (jfj(i),i=1,njfpair)
      READ (1,rec=2) (jff(i),i=1,njfpair)
      CLOSE (1)
      WRITE (*,9007) oldzone,njfpair
c
c...Read Raw Files And Save Pairs
c
      CALL jfraw(1,sjname,njfpair,jfj,x1,y1,m1,err)
      IF (err.ne.0) RETURN
      CALL jfraw(2,sfname,njfpair,jff,x2,y2,m2,err)
      IF (err.ne.0) RETURN
      CALL undistort1(njfpair)
      CALL undistort2(njfpair)
      IF (dotaff.ne.0) THEN
        CALL taffload1
        CALL taffload2
        CALL taffproc1(njfpair)
        CALL taffproc2(njfpair)
      ENDIF
      CALL jfmerge
c
c...All Done
c
      err = 0
      RETURN
c
c...Bad Errors
c
  200 err = -6
      RETURN
      END
