      SUBROUTINE  dsteval
c
c...Look At Distance Between Pairs
c
      INCLUDE
     *            'sdss.inc'
      INTEGER
     *            nl1, nl2, nkeep, test, low, high, xmin, xmax,
     *            ymin, ymax, ki1, kj1, ki2, kj2, i, j
      DOUBLE PRECISION
     *            smin, smax, xi1, eta1, xi2, eta2, dxi, deta,
     *            xhat1, yhat1, xhat2, yhat2, dx, dy, rc, rs
c
c...Make A List Of DX/DY For List (1)
c
  100 nl1 = 0
      DO i=1,np1
        DO j=1,np1
          IF (i.ne.j) THEN
            nl1 = nl1+1
            dx1(nl1) = xp1(j)-xp1(i)
            dy1(nl1) = yp1(j)-yp1(i)
            ii1(nl1) = i
            jj1(nl1) = j
            idx(nl1) = nl1
          ENDIF
        ENDDO
      ENDDO
      CALL iuqsrt(nl1,dx1,idx)
      CALL ireord(nl1,idx,dy1,tmp)
      CALL ireord(nl1,idx,ii1,tmp)
      CALL ireord(nl1,idx,jj1,tmp)
c
c...Make A list Of DX/DY For List (2)
c
      nl2 = 0
      DO i=1,np2
        DO j=1,np2
          IF (i.ne.j) THEN
            nl2 = nl2+1
            dx2(nl2) = xp2(j)-xp2(i)
            dy2(nl2) = yp2(j)-yp2(i)
            ii2(nl2) = i
            jj2(nl2) = j
            idx(nl2) = nl2
          ENDIF
        ENDDO
      ENDDO
      CALL iuqsrt(nl2,dx2,idx)
      CALL ireord(nl2,idx,dy2,tmp)
      CALL ireord(nl2,idx,ii2,tmp)
      CALL ireord(nl2,idx,jj2,tmp)
c
c...See If There Are Matches Within The Specified Tolerance
c
      smin = (1.0D00-stol)
      smax = (1.0D00+stol)
      nkeep = 0
      test = 0
      low = 1
      high = 1
  110 test = test+1
      IF (test.gt.nl1) GO TO 140
      IF (dx1(test).lt.0) THEN
        xmin = smax*dx1(test)
        xmax = smin*dx1(test)
      ELSE
        xmin = smin*dx1(test)
        xmax = smax*dx1(test)
      ENDIF
      IF (dy1(test).lt.0) THEN
        ymin = smax*dy1(test)
        ymax = smin*dy1(test)
      ELSE
        ymin = smin*dy1(test)
        ymax = smax*dy1(test)
      ENDIF
  120 IF (dx2(low).lt.xmin) THEN
        IF (low.lt.nl2) THEN
          low = low+1
          GO TO 120
        ELSE
          GO TO 110
        ENDIF
      ENDIF
      IF (dx2(low).gt.xmax) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 IF (high.lt.nl2) THEN
        IF (dx2(high+1).le.xmax) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test In DY
c
      DO i=low,high
        IF ((dy2(i).ge.ymin).and.(dy2(i).le.ymax)) THEN
          ki1 = ii1(test)
          kj1 = jj1(test)
          ki2 = ii2(i)
          kj2 = jj2(i)
          xi1  = xp1(ki1)/P12SCALE
          eta1 = yp1(ki1)/P12SCALE
          xi2  = xp1(kj1)/P12SCALE
          eta2 = yp1(kj1)/P12SCALE
          xhat1 = xp2(ki2)/P12SCALE
          yhat1 = yp2(ki2)/P12SCALE
          xhat2 = xp2(kj2)/P12SCALE
          yhat2 = yp2(kj2)/P12SCALE
          dxi = xi2-xi1
          deta = eta2-eta1
          dx = xhat2-xhat1
          dy = yhat2-yhat1
          rc = (dxi*dx + deta*dy)/(dx*dx + dy*dy)
          rs = (dxi*dy - deta*dx)/(dx*dx + dy*dy)
          xcoef(1) = xi1 - (rc*xhat1 + rs*yhat1)
          xcoef(2) = rc
          xcoef(3) = rs
          ycoef(1) = eta1 - (rc*yhat1 - rs*xhat1)
          ycoef(2) = -rs
          ycoef(3) = rc
          ncoef = 3
          CALL smallxform
          CALL dstfind
c     write (*,9991) i,ki1,kj1,ki2,kj2,xcoef(1),xcoef(2),
c    * xcoef(3),ycoef(1),ycoef(2),ycoef(3),npair
 9991 format (5i4, 2(f9.2,2f9.5), i4)
          IF (npair.ge.npairmin) RETURN
        ENDIF
      ENDDO
      GO TO 110
c
c...We Are Lost If We Get Here
c
  140 CONTINUE
      npair = -1
      RETURN
      END
