      SUBROUTINE  init
c
c...Initialize Things In Common Block
c
      INCLUDE
     *            'sdss.inc'
c
  100 twopi = 8.0D00*ATAN(1.0D00)
      radian = 360.0D00/twopi
      oldzone = -1
      telscale = 13.55D00*0.024D00
      l1mult = 1.0D00/telscale
      l2mult = (3600.0D00*radian)/telscale
      halfwide = 0.12D00
      obs_scale = 67.18D00
      obs_unit = 3600.0D00*100000.0D00*radian/obs_scale
      obs_disco = -0.3333D00
c
c...Load List Of POSS-II Centers and Corners
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='../../binary/corners/p2corn.dat',
     *      readonly,
     *      recl=(20*NPOSSII),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) p2buf
      CLOSE (1)
c
c...Load Color Conversion Tables
c
      CALL loadtable
      CALL loadaah
      RETURN
      END
