      SUBROUTINE  get2mass
c
c...Read 2MASS Stars File
c
      INCLUDE
     *            'ua2mass.inc'
      INTEGER
     *            i, IARGC, n
      DOUBLE PRECISION
     *            x, y, z, r50, d50, r20, d20, ep
c
 9001 FORMAT (' Enter 2MASS Field: ' $)
 9002 FORMAT (q, a)
 9004 FORMAT (' Cannot Open ', a)
 9005 FORMAT (i6, 2f10.0, f9.0)
c
      n = IARGC()
  100 IF (n.gt.0) THEN
        CALL getarg(1,sname)
        nsname = 0
        DO i=1,LEN(sname)
          IF (sname(i:i).le.' ') THEN
            GO TO 110
          ELSE
            nsname = nsname+1
          ENDIF
        ENDDO
  110   n = 0
      ELSE
  120   WRITE (*,9001)
        READ  (*,9002,err=120,end=210) nsname,sname
        IF (nsname.le.0) GO TO 120
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='/dgm/2mass/'//sname(1:nsname),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
c
c...Gobble It
c
      ep = 1995.0D00
      nu = 0
      DO i=1,3
        READ (1,9005)
      ENDDO
  130 READ (1,9005,err=130,end=140) i,x,y,z
      IF (z.gt.faint) GO TO 130
      nu = nu+1
      CALL fromhms(x,r50)
      CALL fromdms(y,d50)
      r50 = r50/radian
      d50 = d50/radian
      CALL sla_FK45Z(r50,d50,ep,r20,d20)
      uxx(nu) = r20*radian
      uyy(nu) = d20*radian
      umm(nu) = z
      uid(nu) = i
      GO TO 130
  140 CLOSE (1)
      RETURN
c
c...Errors
c
  200 WRITE (*,9004) sname(1:nsname)
      GO TO 100
  210 CALL EXIT
      END
