      SUBROUTINE  pairfind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'ua.inc'
      PARAMETER
     *            nqmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind,
     *            ifind(NQMAX), jfind(NQMAX), test, yl,
     *            yh, yt, rfind(NQMAX), z
      DOUBLE PRECISION
     *            dx, dy, dr, rsqr
c
c...Initialization
c
  100 get = 0
      npair = 0
      low = 1
      high = 1
      r = radius*P12SCALE + 0.5D00
      rsqr = (r/P12SCALE)**2
c
c...Outer Loop Over (1) Index
c
  110 get = get+1
      IF (get.gt.nu) THEN
        RETURN
      ENDIF
      xl = uxsav(get) - r
      xh = uxsav(get) + r
      yl = uysav(get) - r
      yh = uysav(get) + r
c
c...Inner Loop Brackets (2)
c
  120 CONTINUE
      IF (x2hat(low).lt.xl) THEN
        IF (low.lt.nsav) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (x2hat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.nsav) THEN
        IF (x2hat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Entries In This Range
c
      nfind = 0
      DO test=low,high
        yt = y2hat(test)
        IF ((yt.ge.yl).and.(yt.le.yh)) THEN
          dy = ((yt-uysav(get))/P12SCALE)**2
          IF (dy.le.rsqr) THEN
            dx = ((x2hat(test)-uxsav(get))/P12SCALE)**2
            dr = dx+dy
            IF (dr.le.rsqr) THEN
              IF (nfind.lt.NQMAX) THEN
                nfind = nfind+1
                ifind(nfind) = get
                jfind(nfind) = idx(test)
                rfind(nfind) = P12SCALE*SQRT(dr)
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        npair = npair+1
        pair1(npair) = ifind(1)
        pair2(npair) = jfind(1)
        pair3(npair) = rfind(1)
        z = rfind(1)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            pair1(npair) = ifind(test)
            pair2(npair) = jfind(test)
            pair3(npair) = rfind(test)
            z = rfind(test)
          ENDIF
        ENDDO
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
