      PROGRAM  readnvss
c
c...Read Binary FITS Table
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nnvss = 865609
      INTEGER
     *         fd, C_ROOPEN, C_POSITION, C_READER, i, err, nlb,
     *         jdproc, C_RAWREAD, j, count, id(NNVSS), idx(NNVSS),
     *         ira(NNVSS), ispd(NNVSS), imag(NNVSS), tmp(NNVSS)
      BYTE
     *         bb(2880), fb(8)
      DOUBLE PRECISION
     *         ra, dec, r1950, d1950, epoch, r2000, d2000, convert,
     *         radian, equator
      REAL
     *         peak, major, minor, angle, qcent, ucent, pflux,
     *         irms, polrms, resrms, respeak, resflux, centx,
     *         centy
      CHARACTER*8
     *         field
      CHARACTER*80
     *         lb
      EQUIVALENCE
     *      (bb( 1),ra),     (bb( 9),dec),
     *      (bb(17),peak),   (bb(21),major),
     *      (bb(25),minor),  (bb(29),angle),
     *      (bb(33),qcent),  (bb(37),ucent),
     *      (bb(41),pflux),  (bb(45),irms),
     *      (bb(49),polrms), (bb(53),resrms),
     *      (bb(57),respeak),(bb(61),resflux),
     *      (bb(65),centx),  (bb(69),centy),
     *      (bb(73),fb(1)),  (bb(81),jdproc)
c
c...Open The File
c
  100 CALL f_doenv('/uz6/xpmm/sg5/tycho/nvss.fits',nlb,lb)
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      fd = C_ROOPEN(bb)
      IF (fd.le.2) THEN
        STOP 'Cannot Open File'
      ENDIF
      radian = 45.0D00/ATAN(1.0D00)
      convert = radian*3600.0D00*100.0D00
      equator = 90.0D00*3600.0D00*100.0D00
c
c...Skip The Header
c
      count = 0
  110 err = C_RAWREAD(fd,bb,2880)
      DO j=1,36
        DO i=1,80
          lb(i:i) = CHAR(ZEXT(bb(j*80+i)))
        ENDDO
        IF (lb(1:8).eq.'END     ') THEN
          count = count+1
          IF (count.lt.2) GO TO 110
          GO TO 120
        ENDIF
      ENDDO
      GO TO 110
  120 CONTINUE
c
c...Try To Read
c
      DO i=1,NNVSS
        err = C_RAWREAD(fd,bb,84)
        IF (err.ne.0) THEN
          STOP 'Read Error'
        ENDIF
        CALL swap8(ra)
        CALL swap8(dec)
        CALL swap4(peak)
        r1950 = ra/radian
        d1950 = dec/radian
        epoch = 1996.0D00
c
c...Not Sure About Precession
c
c       CALL sla_FK45Z(r1950,d1950,epoch,r2000,d2000)
        r2000 = r1950
        d2000 = d1950
c
c...OK To Proceed
c
        ira(i) = r2000*convert
        ispd(i) = d2000*convert + equator
        imag(i) = 100.0D00*(7.5D00 - 2.5D00*LOG10(peak))
        idx(i) = i
      if (i.ge.(nnvss-20)) then
      write (*,9991) ra,dec,r2000,d2000,ira(i),ispd(i)
 9991 format (4f10.6, 2i10)
      endif
      ENDDO
c
c...Sort On RA
c
      CALL iuqsrt(NNVSS,ira,idx)
      CALL ireord(NNVSS,idx,ispd,tmp)
      CALL ireord(NNVSS,idx,imag,tmp)
c
c...Save As A Direct Access File
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uz6/xpmm/sg5/tycho/nvss.bin',
     *      recl=NNVSS,
     *      recordtype='fixed',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,rec=1) (ira(i),i=1,NNVSS)
      WRITE (1,rec=2) (ispd(i),i=1,NNVSS)
      WRITE (1,rec=3) (imag(i),i=1,NNVSS)
      WRITE (1,rec=4) (idx(i),i=1,NNVSS)
      CLOSE (1)
c
c...All Done
c
      CALL c_closer(fd)
      CALL EXIT
      END
