      PROGRAM  uanvss
c
c...Compare USNO-A With NVSS Regions
c
      INCLUDE
     *         'uanvss.inc'
      INTEGER
     *         i, j, err, n, s, iloop, nloop
      CHARACTER*10
     *         cb
      DOUBLE PRECISION
     *         rmin, dmin, rmax, dmax
c
 9001 FORMAT (' ', a, '  N(NVSS)=', i8, '  N(USNO-A)=', i8)
 9002 FORMAT (a, 2i5)
c
c...These Two Variables Define The Units
c
  100 scale = 1.0D00
      radius = 4.0D00
      ncoef = 1
      faint = 0.0
      xerr =  100.0D00/3600.0D00
      yerr = xerr
      CALL init
      CALL loadnvss
c
c...Define The Loop
c
      rmin = 12.0D00
      rmax = 13.0D00
      dmin = 22.5D00
      dmax = 37.5D00
      nloop = 2
c
c...Loop
c
      DO iloop=1,nloop
        radius = 20.0D00 + 5.0D00*iloop
        CALL getnvss(rmin,dmin,rmax,dmax)
        CALL corner
        CALL uproject
        nsav = 0
        DO j=1,ndec
          DO i=1,nra
            CALL eatit(rfrst(i),rlast(i),dzone(j),dfrst(j),dlast(j))
          ENDDO
        ENDDO
        CALL project
        DO i=1,nsav
          idx(i) = i
        ENDDO
        CALL iuqsrt(nsav,xxsav,idx)
        CALL ireord(nsav,idx,yysav,tmp)
        DO i=1,5
          CALL ireord(nsav,idx,sav(1,i),tmp)
        ENDDO
        WRITE (*,9001) sname(1:nsname),nu,nsav
        CALL iterate(err)
        IF (err.eq.0) THEN
c9999     CALL saveit
        ENDIF
      ENDDO
c
c...All Done
c
      CALL EXIT
      END
