      SUBROUTINE  xfindhuge_4
c
c...Finds Huge Objects
c
      INCLUDE
     *            '../all4.inc'
      PARAMETER
     *            minarea=20,
     *            nmax = 50
      INTEGER
     *            ledge(mrows), redge(mrows), column(mrows), j,
     *            ix, iy, i, nput, il, ir, jx, jy, jm, jx1, jx2,
     *            curarea, ii(NMAX), nn, n, xx(NMAX), yy(NMAX),
     *            kx, ky, nc
      REAL
     *             a, x, y, w, dx, dy, test, mm(NMAX)
c
c...Count All Of DN1P And RETURN If Empty
c
  100 CALL xfindadd_4(curarea,minarea)
      IF (curarea.lt.minarea) RETURN
c
c...General Blob Finder
c
      nn = 0
  110 DO iy=1,mrows
        DO ix=1,mcols
c
c...Pixel Must Be ON
c
          IF (dn2p(ix,iy).eq.0) GO TO 140
          jx = ix
          jy = iy
          nput = 0
c
c...Find Extent On This Row
c
  120     CALL xfindonoff_4(jx,jy, il,ir)
          nput = nput+1
          ledge(nput) = il
          redge(nput) = ir
          column(nput) = jy
c
c...Can Any Pixel On The Next Row Touch These Pixels?
c
c	If so, loop back to scan for contiguous pixels.
c
          jy = jy+1
          IF (jy.gt.mrows) GO TO 130
          jx1 = MAX(    1, il-1)
          jx2 = MIN(mcols, ir+1)
          DO jx=jx1,jx2
            IF (dn2p(jx,jy).ne.0) GO TO 120
          ENDDO
c
c...No.  Process this detection.
c
  130     a = 0.0
          x = 0.0
          y = 0.0
          DO i=1,nput
            DO jx=ledge(i),redge(i)
              w = dn2p(jx,column(i))
              dn2p(jx,column(i)) = 0
              x = x + w*jx
              y = y + w*column(i)
              a = a + w
            ENDDO
          ENDDO
          IF (a.ge.MINAREA) THEN
            kx = TRUEFC + (x/a-1.0)*MAGNIFY
            ky = TRUEFR + (y/a-1.0)*MAGNIFY
            CALL plsat(kx,ky,j)
            IF (j.eq.0) THEN
              nn = nn+1
              xx(nn) = kx
              yy(nn) = ky
              mm(nn) = a
              ii(nn) = nn
              IF (nn.ge.NMAX) GO TO 150
            ENDIF
          ENDIF
          curarea = curarea - a
          nput = 0
c
c...End Of Pixel Scanning Loop
c
  140   CONTINUE
        ENDDO
      ENDDO
      IF (curarea.ge.minarea) THEN
        GO TO 110
      ENDIF
c
c...See What We Found.  Sort List By Brightness.
c
  150 IF (nn.le.0) RETURN
      IF (nn.gt.1) THEN
        CALL fdqsrt(nn,mm,ii)
      ENDIF
      test = frdn2(nframe)
c
c...Keep The First Entry
c
      nc = 0
  160 jx = xx(ii(1))
      jy = yy(ii(1))
      jm = mm(1)
      nc = nc+1
      CALL pllog_4(jx,jy,jm,nc,nc)
      jx = xstar(nstar)
      jy = ystar(nstar)
      IF (nn.le.1) RETURN
c
c...Remove First And All Entries We Can Get To By Crossing Saturated Pixels
c
      ii(1) = -1
      DO i=2,nn
        dx = xx(ii(i)) - jx
        dy = yy(ii(i)) - jy
        n = MAX(ABS(dx),ABS(dy))
        IF (n.gt.1) THEN
          dx = dx/n
          dy = dy/n
        ENDIF
        DO j=1,n-1
          ix = jx + j*dx
          iy = jy + j*dy
          IF (data(ix,iy).lt.test) GO TO 170
        ENDDO
        ii(i) = -1
  170   CONTINUE
      ENDDO
c
c...Remove Deleted Entries And Try Again
c
      j = 0
      DO i=1,nn
        IF (ii(i).gt.0) THEN
          j = j+1
          ii(j) = ii(i)
          mm(j) = mm(i)
        ENDIF
      ENDDO
      nn = j
      IF (nn.gt.0) GO TO 160
      RETURN
      END
