      SUBROUTINE  cc_interpz(who,iya,iyb,nyy,iyy,err)
c
c...Interpolate Z(X) For A Particular Y Value
c
      INCLUDE
     *            'c.inc'
      CHARACTER*(*)
     *            who
      CHARACTER*19
     *            fn
      INTEGER
     *            iya, iyb, nyy, iyy(*), i, na, nb, err, loop, nx,
     *            a, b
      REAL
     *            xa(NTBLMAX), za(NTBLMAX), xb(NTBLMAX), zb(NTBLMAX),
     *            ya, yb, xx, yy, zz, fy, xmin, xmax, dx, zfa, zfb, fx
c
 9001 FORMAT ('[-.SAMPLE]ZTBL', a, '.', i3.3)
 9002 FORMAT (i2)
 9003 FORMAT (2f10.4)
 9004 FORMAT (/ ' Error In INTERPZ', 3i8 /)
 9005 FORMAT (/ ' INTERPZ Read Error ', a /)
c
c...Open And Read A File
c
  100 IF (iya.eq.iyb) GO TO 200
      WRITE (fn,9001,err=200) who,iya
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=fn,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=88
     *     )
      READ (88,9002,err=210) na
      DO i=1,na
        READ (88,9003) xa(i),za(i)
      ENDDO
      CLOSE (88)
      IF (na.le.10) GO TO 200
      ya = iya
c
c...Open And Read B File
c
      WRITE (fn,9001,err=200) who,iyb
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=fn,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=88
     *     )
      READ (88,9002,err=210) nb
      DO i=1,nb
        READ (88,9003) xb(i),zb(i)
      ENDDO
      CLOSE (88)
      IF (nb.le.10) GO TO 200
      yb = iyb
c
c...Loop Over Interpolation Requests
c
      nx = NTBLMAX
      xmin = MAX(xa( 1),xb( 1))
      xmax = MIN(xa(na),xb(nb))
      dx = (xmax-xmin)/NTBLMAX
      DO loop=1,nyy
        WRITE (fn,9001,err=200) who,iyy(loop)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name=fn,
     *        status='unknown',
     *        unit=88
     *       )
        yy = iyy(loop)
        fy = MAX(0.0,MIN(1.0,(yy-ya)/(yb-ya)))
        WRITE (88,9002) nx
        a = 1
        b = 1
        DO i=1,nx
          xx = xmin + (i-1)*dx
          IF (xx.gt.xa(a+1)) THEN
            a = MIN(a+1,na-1)
          ENDIF
          fx = (xx-xa(a))/(xa(a+1)-xa(a))
          zfa = za(a) + fx*(za(a+1)-za(a))
          IF (xx.gt.xb(b+1)) THEN
            b = MIN(b+1,nb-1)
          ENDIF
          fx = (xx-xb(b))/(xb(b+1)-xb(b))
          zfb = zb(b) + fx*(zb(b+1)-zb(b))
          zz = zfa + fy*(zfb-zfa)
          WRITE (88,9003) xx,zz
        ENDDO
        CLOSE (88)
      ENDDO
      err = 0
      RETURN
c
c...Error Exits
c
  200 WRITE (*,9004) iya,iyb
      RETURN
  210 CLOSE (88)
      WRITE (*,9005) fn
      RETURN
      END
