      SUBROUTINE  cc_loadoff
c
c...Load (Laser-Camera) Offsets
c
      INCLUDE
     *            'c.inc'
      INTEGER
     *            i, j
      DOUBLE PRECISION
     *            x, y
c
 9001 FORMAT (4f20.0)
c
c...Default State
c
  100 DO j=1,2
        DO i=1,2
          laseroff(i,j) = 0.0D00
        ENDDO
      ENDDO
      golaser = 0
c
c...Load Calibrated Values (If Available)
c
      OPEN (
     *    access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=120,
     *      form='formatted',
     *      name='OFFSET.0',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=88
     *     )
      READ (88,9001,err=110) x,y
      laseroff(1,1) = x
      laseroff(2,1) = y
  110 CLOSE(88)
  120 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=140,
     *      form='formatted',
     *      name='OFFSET.1',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=88
     *     )
      READ (88,9001,err=130) x,y
      laseroff(1,2) = x
      laseroff(2,2) = y
  130 CLOSE (88)
  140 CONTINUE
      RETURN
      END
