      SUBROUTINE  cc_sample(err)
c
c...Sample Of Z Sensors While Stage Is Moving
c
c	WARNING!!!  FRACTION Tuned For PMM Speed=4000 By Comparing
c			Encoder Readings From Forward And Reverse Scans!!!!
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            MAX_SAMP_TIME = 60.0,
     *            FRACTION = 0.48D00
      INTEGER
     *            err, ready, nsample, i, iy
      REAL
     *            t0, t1, t2, t
      DOUBLE PRECISION
     *            x0, y0, z0, x1, y1, z1, a, x0min, x0max, x1min,
     *            x1max, x0old, x1old, x
      BYTE
     *            sx, sy
      CHARACTER*19
     *            tb0, tb1
c
 9001 FORMAT (i8, 3f10.4, f10.2, i8)
 9002 FORMAT ('[-.SAMPLE]SMPL0.', i3.3)
 9003 FORMAT ('[-.SAMPLE]SMPL1.', i3.3)
c
c...Open Output Files.  File Name Includes Camera And Corrected Y
c
  100 CALL cc_fastxyz(err)
      IF (err.ne.0) RETURN
      iy = curpos(2) - laseroff(2,1) + 0.5D00
      iy = MAX(0,MIN(999,iy))
      WRITE (tb0,9002) iy
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb0,
     *      status='unknown',
     *      unit=87
     *     )
      iy = curpos(2) - laseroff(2,2) + 0.5D00
      iy = MAX(0,MIN(999,iy))
      WRITE (tb1,9003) iy
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb1,
     *      status='unknown',
     *      unit=89
     *     )
c
c...Preliminaries Before Scan, Then MOVE Without Sleep
c
      CALL cc_anostat(ready)
      IF (ready.ne.1) THEN
        err = -36
        RETURN
      ENDIF
      CALL cc_move(err)
      IF (err.ne.0) GO TO 210
      t0 = SECNDS(0.0)
      nsample = 0
      n0fit = 0
      n1fit = 0
      IF (fitselect.eq.1) THEN
        x0min = fit0min(1)
        x0max = fit0max(1)
        x1min = fit1min(1)
        x1max = fit1max(1)
      ELSE
        x0min = fit0min(2)
        x0max = fit0max(2)
        x1min = fit1min(2)
        x1max = fit1max(2)
      ENDIF
      x0old = x0min
      x1old = x1min
c
c...Loop Begins With Sample And Save
c
  110 t1 = SECNDS(t0)
      CALL cc_fastxyz(err)
      IF (err.ne.0) GO TO 210
      x0 = curpos(1) - laseroff(1,1)
      y0 = curpos(2) - laseroff(2,1)
      CALL cc_relza('0',z0,a)
      x1 = curpos(1) - laseroff(1,2)
      y1 = curpos(2) - laseroff(2,2)
      CALL cc_relza('1',z1,a)
      t2 = SECNDS(t0)
      t = 0.5*(t1+t2)
      nsample = nsample+1
      IF (nsample.eq.1) THEN
        x = x0
      ELSE
        x = x0 + FRACTION*(x0-x0old) 
      ENDIF
      IF ((x.ge.x0min).and.(x.le.x0max)) THEN
        n0fit = MIN(n0fit+1,NFITMAX)
        x0fit(n0fit) = x
        y0fit(n0fit) = z0
        WRITE (87,9001) nsample,x,y0,z0,t,n0fit
      ELSE
        WRITE (87,9001) nsample,x,y0,z0,t
      ENDIF
      IF (nsample.eq.1) THEN
        x = x1
      ELSE
        x = x1 + FRACTION*(x1-x1old)
      ENDIF
      IF ((x.ge.x1min).and.(x.le.x1max)) THEN
        n1fit = MIN(n1fit+1,NFITMAX)
        x1fit(n1fit) = x
        y1fit(n1fit) = z1
        WRITE (89,9001) nsample,x,y1,z1,t,n1fit
      ELSE
        WRITE (89,9001) nsample,x,y1,z1,t
      ENDIF
      x0old = x0
      x1old = x1
c
c...PMM Status Ends SAMPLE Loop
c
      CALL py_oldgrab
      CALL cc_anoaxis(xcol,xrow,sx)
      CALL cc_anoaxis(ycol,yrow,sy)
      IF ((sx.eq.'R').and.(sy.eq.'R')) THEN
        ready = 1
      ELSE
        ready = 0
      ENDIF
      IF ((ready.eq.0).and.(t2.le.MAX_SAMP_TIME)) GO TO 110
c
c...All Done
c
      CLOSE (87)
      CLOSE (89)
      IF (ready.eq.0) THEN
        lb(1:4) = 'WAIT'
        nlb = 4
        CALL cc_wait(err)
      ELSE
        ano_seq = 0
        err = 0
      ENDIF
      tb0(11:14) = 'COEF'
      CALL cc_dozfit(n0fit,x0fit,y0fit,tb0)
      tb1(11:14) = 'COEF'
      CALL cc_dozfit(n1fit,x1fit,y1fit,tb1)
      CALL cc_fitload(curpos(2))
      RETURN
c
c...Error Exits
c
  200 err = -37
      RETURN
  210 CLOSE (87)
      CLOSE (89)
      err = -38
      RETURN
      END
