      SUBROUTINE  cc_sg0proc
c
c...Monitor Processing By SG0
c
      INCLUDE
     *            'c.inc'
      CHARACTER*12
     *            now
      INTEGER
     *            i, err, DEV_STTSGREAD, nbb, j
      BYTE
     *            bb(NIOMAX)
      REAL
     *            dt
c
 9001 FORMAT (' Illegal SG0_SEQ = ', i10, 1x, a)
c
c...Quick Return If Nothing To Do
c
  100 IF (sg0_open.le.0) RETURN
      IF (sg0_seq.eq.0) RETURN
c
c...Illegal Values Of SEQ
c
      IF ((sg0_seq.lt.0).or.(sg0_seq.gt.1)) THEN
        CALL cc_gettime(now)
        WRITE (*,9001) sg0_seq,now
        sg0_seq = 0
        RETURN
      ENDIF
c
c...Read Message If One Is Present
c
      nbb = NIOMAX
      err = DEV_STTSGREAD(nbb,bb)
      IF (err.ne.0) THEN
        panic = IOR(panic,PANIC_SG0_TE)
        sg0_seq = 0
        RETURN
      ENDIF
c
c...Parse The Message
c
c	E In Message Means Error On Previous Command
c	K In Message Means OK On Previous Command
c
      DO i=1,nbb
        nrcv0 = nrcv0+1
        rcv0(nrcv0) = bb(i)
        IF (rcv0(nrcv0).eq.'E') THEN
          panic = IOR(panic,PANIC_SG0_QIO)
        ENDIF
        IF (rcv0(nrcv0).eq.'K') THEN
          sg0_seq = 0
        ENDIF
      ENDDO
c
c...If Still Not Done, See If We Are Overdue
c
      IF (sg0_seq.gt.0) THEN
        CALL cc_getdt(sg0_time,dt)
        IF (dt.gt.sg0_dt) THEN
          panic = IOR(panic,PANIC_SG0_DT)
          sg0_seq = 0
        ENDIF
        RETURN
      ENDIF
      RETURN
      END
