      SUBROUTINE  cc_sg1proc
c
c...Monitor Processing By SG1
c
      INCLUDE
     *            'c.inc'
      CHARACTER*12
     *            now
      INTEGER
     *            i, err, DEV_XTTSGREAD, nbb, j
      BYTE
     *            bb(NIOMAX)
      REAL
     *            dt
c
 9001 FORMAT (' Illegal SG1_SEQ = ', i10, 1x, a)
c
c...Quick Return If Nothing To Do
c
  100 IF (sg1_open.le.0) RETURN
      IF (sg1_seq.eq.0) RETURN
c
c...Illegal Values Of SEQ
c
      IF ((sg1_seq.lt.0).or.(sg1_seq.gt.1)) THEN
        CALL cc_gettime(now)
        WRITE (*,9001) sg1_seq,now
        sg1_seq = 0
        RETURN
      ENDIF
c
c...Read Message If One Is Present
c
      nbb = NIOMAX
      err = DEV_XTTSGREAD(nbb,bb)
      IF (err.ne.0) THEN
        panic = IOR(panic,PANIC_SG1_TE)
        sg1_seq = 0
        RETURN
      ENDIF
c
c...Parse The Message
c
c	E In Message Means Error On Previous Command
c	K In Message Means OK On Previous Command
c
      DO i=1,nbb
        nrcv1 = nrcv1+1
        rcv1(nrcv1) = bb(i)
        IF (rcv1(nrcv1).eq.'E') THEN
          panic = IOR(panic,PANIC_SG1_QIO)
        ENDIF
        IF (rcv1(nrcv1).eq.'K') THEN
          sg1_seq = 0
        ENDIF
      ENDDO
c
c...If Still Not Done, See If We Are Overdue
c
      IF (sg1_seq.gt.0) THEN
        CALL cc_getdt(sg1_time,dt)
        IF (dt.gt.sg1_dt) THEN
          panic = IOR(panic,PANIC_SG1_DT)
          sg1_seq = 0
        ENDIF
        RETURN
      ENDIF
      RETURN
      END
