      SUBROUTINE  cc_take(err)
c
c...Monitor PMM During Exposure
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            itmax = 4,
     *            siglim = 0.00033D00
      CHARACTER*16
     *            cmd
      CHARACTER*5
     *            saveit
      CHARACTER*1
     *            who
      INTEGER
     *            ncmd, iter, err, noise, kill
c
 9001 FORMAT (/ ' TAKE Was Too Noisy' /)
 9002 FORMAT (/ ' Noisy TAKE ', i4, 4f10.5, f6.1 /)
 9003 FORMAT (/ ' TAKE SG0 Err=', i10 /)
 9004 FORMAT (/ ' TAKE SG1 Err=', i10 /)
 9005 FORMAT (/ ' TAKE ANO Err=', i10 /)
c
c...Sanity Checking And Prepare Command
c
  100 IF (nlb.le.4) THEN
        err = -1
        RETURN
      ENDIF
      kill = 0
      saveit = lb(1:5)
c
c...Enter Here To Do Something
c
  105 who = lb(5:5)
      IF ((who.ne.'0').and.(who.ne.'1')) THEN
        err = -2
        RETURN
      ENDIF
      IF (nlb.le.5) THEN
        cmd = who//'=TAKE'
        ncmd = 6
      ELSE
        cmd = who//'=TAKE='//lb(6:nlb)
        ncmd = 7 + (nlb+1-6)
      ENDIF
      iter = 0
      noise = 0
c
c...Loop To Do Exposure And Sample X,Y During It
c
  110 iter = iter+1
      takeflag = 1
      nlb = ncmd
      lb(1:nlb) = cmd(1:ncmd)
      IF (who.eq.'0') THEN
        CALL cc_sg0talk(err)
        takeflag = 0
        IF (err.ne.0) GO TO 300
      ELSE
        CALL cc_sg1talk(err)
        takeflag = 0
        IF (err.ne.0) GO TO 310
      ENDIF
c
c...Do Statistics
c
      IF (take(5).le.0.0D00) THEN
        CALL cc_fastxyz(err)
        IF (err.ne.0) GO TO 320
        take(1) = curpos(1)
        take(2) = 0.0D00
        take(3) = curpos(2)
        take(4) = 0.0D00
      ELSEIF (take(5).le.1.0D00) THEN
        take(2) = 0.0D00
        take(4) = 0.0D00
      ELSE
        take(1) = take(1)/take(5)
        take(2) = SQRT(ABS(take(2)/take(5) - take(1)*take(1)))
        take(3) = take(3)/take(5)
        take(4) = SQRT(ABS(take(4)/take(5) - take(3)*take(3)))
      ENDIF
c
c...Is This OK.  Not Much We Can Do If All Tries Fail
c
      IF ((take(2).gt.SIGLIM).or.(take(4).gt.SIGLIM)) THEN
        IF (iter.gt.2) THEN
          WRITE (*,9002) iter,take(1),take(2),take(3),take(4),take(5) 
        ENDIF
        IF (iter.le.ITMAX) GO TO 110
        WRITE (*,9001)
        noise = 1
      ENDIF
c
c...Generate A Simple UPDATE From Means
c
      curpos(1) = take(1)
      curpos(2) = take(3)
      nlb = 7
      lb = 'UPDATE'//who//' '
      CALL cc_update(err,noise)
      RETURN
c
c...Tracking Down Errors Here
c
  300 WRITE (*,9003) err
      lb(1:6) = 'CLEAR0'
      nlb = 6
      CALL cc_clear(iter)
      GO TO 330
  310 WRITE (*,9004) err
      lb(1:6) = 'CLEAR1'
      nlb = 6
      CALL cc_clear(iter)
      GO TO 330
  320 WRITE (*,9005) err
      lb(1:6) = 'CLEARA'
      nlb = 6
      CALL cc_clear(iter)
  330 kill = kill+1
      IF (kill.le.3) THEN
        nlb = 5
        lb(1:nlb) = saveit
        GO TO 105
      ENDIF
      RETURN
      END
