      SUBROUTINE  cc_tempsense(mode,err)
c
c...Sense The Temperature Every Once In A While (MODE==0)
c	Or Right Now (MODE==1)
c
c	WARNING:  This Version Assumes Knob On Temperature Scanner
c		Is Set To "4" == CHAN=5 (==sensor at PMM Z stage)
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            interval = 30
      INTEGER
     *            err, DEV_UTTRW, nbb, i, j, k, tnow, tsave, dt,
     *            chan, t0, mode
      BYTE
     *            bb(20)
      CHARACTER*8
     *            tb
      REAL
     *            temp, sign
      DATA
     *            tsave/-100/
c
 9001 FORMAT (i2, 1x, i2, 1x, i2)
 9002 FORMAT (3i2.2, 3a)
 9003 FORMAT (6f5.1, i6, 5i4, a)
 9004 FORMAT (/ ' Put Temp Meter To Channel 1' /)
 9005 FORMAT ('TEMP.', i2.2, i2.2)
c
c...See If Now Is A Good Time
c
  100 CALL time(tb)
      READ (tb,9001) i,j,k
      tnow = k + 60*j + 3600*i
      dt = tnow - tsave
      IF (mode.eq.0) THEN
        IF ((dt.ge.0).and.(dt.le.INTERVAL)) RETURN
      ENDIF
c
c...Get Bustle Data
c
      nbb = 20
      err = DEV_UTTRW(nbb,bb)
      IF (err.ne.0) RETURN
      IF (nbb.ne.12) THEN
        err = -nbb
        RETURN
      ENDIF
      i = bb(7)
      IF (IAND(8,i).ne.0) THEN
        sign = 1.0
      ELSE
        sign = -1.0
      ENDIF
      i = IAND(i,3)
      j = bb(8)
      k = bb(9)
      temp = sign*(10.0*i + IAND(j,15) + 0.1*IAND(k,15))
      i = bb(10)
      chan = 1+IAND(7,ISHFT(i,-1))
      tempval(chan) = MAX(-9.9,MIN(99.9,temp))
c
c...Complain If Not CHAN==5
c
      IF (chan.ne.5) THEN
        WRITE (*,9004)
        RETURN
      ENDIF
c
c...Save Things Every Now And Then
c
      IF ((dt.lt.0).or.(dt.ge.INTERVAL)) THEN
        ntmp = MIN(ntmp+1,NTMPMAX)
        CALL idate(i,j,k)
        tmpymd(ntmp) = j + 100*i + 10000*k
        READ (tb,9001) i,j,k
        tmphms(ntmp) = k + 100*j + 10000*i
        tmpval(ntmp) = MAX(-9.9,MIN(99.9,temp))
        tsave = tnow
      ENDIF
      RETURN
      END
