c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdopen
c
c...CCD0 Is The DR11 Interface To The CCD
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      INTEGER*4
     *           ret, SYS$ASSIGN, SYS$SETEF
c
  100 ret=SYS$ASSIGN(
     1               'CCA0',
     2               ccd_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccdopen = 1
        RETURN
      ENDIF
      ccd_efn = 44
      ret = SYS$SETEF(%VAL(ccd_efn))
      ccd_iosb(1) = SS$_NORMAL
      dev_ccdopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdclose
c
c...Return CCD0 Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(ccd_chan)
     *                )
      ccd_chan = 0
      ccd_efn = 0
      dev_ccdclose = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccddosh
c
c...Open The Shutter
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(4),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
         dev_ccddosh = -1
      ELSE
         dev_ccddosh = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdnosh
c
c...Close The Shutter
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(0),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccdnosh = -1
      ELSE
        dev_ccdnosh = 0
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccddocw
c
c...Sets CCD Into Continuous Wipe Mode
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(2),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccddocw = -1
      ELSE
        dev_ccddocw = 0
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdnocw
c
c...Restore CCD From Continuous Wipe Mode.  As Per FHH, Wait 2 Seconds
c	Before Continuing
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, DEV_SLEEP
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(0),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccdnocw = -1
      ELSE
        dev_ccdnocw = 0
        ret = DEV_SLEEP(2.0)
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccddoer
c
c...Sets CCD Into Erase Mode
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(3),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccddoer = -1
      ELSE
        dev_ccddoer = 0
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdnoer
c
c...Restore CCD From Erase Mode.  As per FHH, Wait 2 Seconds Before Continuing.
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, DEV_SLEEP
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(0),
     B               %VAL(0),
     C
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ccdnoer = -1
      ELSE
        dev_ccdnoer = 0
        ret = DEV_SLEEP(2.0)
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdread(buf,nbytes,shopen)
c
c...Asynchronous Read A Row
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      PARAMETER
     *            timeout = 2
      INTEGER*4
     *            ret, SYS$QIO
      INTEGER
     *            nbytes, shopen, i
      BYTE
     *            buf(*)
c
  100 IF (shopen.eq.0) THEN
        i = 1
      ELSE
        i = 5
      ENDIF
      ret = SYS$QIO(
     1              %VAL(ccd_efn),
     2              %VAL(ccd_chan),
     3              %VAL(IO$_WRITEVBLK+IO$M_SETFNCT+IO$M_TIMED),
     4              ccd_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(nbytes),
     9              %VAL(timeout),
     A              %VAL(i),
     B             ,
     C
     *             )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_ccdread = 0
      ELSE
        dev_ccdread = ret
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pmmread(buf,nbytes,timeout)
c
c...Asynchronous Read A Row
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIO
      INTEGER
     *            nbytes, i, timeout
      BYTE
     *            buf(*)
c
  100 ret = SYS$QIO(
     1              %VAL(ccd_efn),
     2              %VAL(ccd_chan),
     3              %VAL(IO$_READVBLK+IO$M_TIMED),
     4              ccd_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(nbytes),
     9              %VAL(timeout),
     A             ,
     B             ,
     C
     *             )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_pmmread = 0
      ELSE
        dev_pmmread = ret
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pmmstat(in,out)
c
c...Write FUNC Bits And Read STAT bits
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            reg(2), in, out
      REAL*8
     *            ret, SYS$QIOW
      EQUIVALENCE
     *            (reg,ret)
c
  100 ret = SYS$QIOW(
     1               %VAL(ccd_efn),
     2               %VAL(ccd_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_SETFNCT),
     4               ccd_iosb,
     5              ,
     6              ,
     7               %VAL(0),
     8               %VAL(0),
     9              ,
     A               %VAL(IAND(in,7)),
     B               %VAL(0),
     C
     *              )
      IF (reg(1).ne.SS$_NORMAL) THEN
        dev_pmmstat = -1
        out = reg(1)
      ELSE
        dev_pmmstat = 0
        out = reg(2)
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ccdwait
c
c...Wait For Asynchronous Read Request To Finish
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$READEF, dummy, SYS$WAITFR
c
c  100 ret = SYS$READEF(
c     1                 %VAL(ccd_efn),
c     2                 dummy
c     *                )
c      IF (ret.eq.SS$_WASCLR) GO TO 100
  100 ret = SYS$WAITFR(
     1                 %VAL(ccd_efn)
     *                )
c
      IF (ccd_iosb(1).eq.SS$_NORMAL) THEN
        dev_ccdwait = 0
      ELSE
        dev_ccdwait = ccd_iosb(1)
      ENDIF
      RETURN
      END
