      PROGRAM  daemon
c
c...Daemon For Monitoring Temperature
c
      IMPLICIT
     *           NONE
      PARAMETER
     *           tau = 3.0,
     *           nkeep = 300,
     *           tau1 = 0.0,
     *           tau2 = 2.0
      INTEGER
     *           err, DEV_TIMOPEN, DEV_UTTOPEN, DEV_SLEEP, DEV_UTTRW,
     *           nbb, i, j, k, chan, DEV_PYOPEN, who, tryit, l,
     *           DEV_GETPRIV, doinit
      REAL
     *           sign, temp, tempval(6), timeval(6), timekeep(NKEEP),
     *           tempkeep(6,NKEEP), xtime(NKEEP), xtemp(6,NKEEP),
     *           faren(6)
      BYTE
     *           bb(20)
      CHARACTER*4
     *           mmdd
      CHARACTER*8
     *           tb
c
 9001 FORMAT (' TIM_IO Error ', i10)
 9002 FORMAT (' UTT_IO Error ', i10)
 9003 FORMAT (' SLEEP Error ', i10)
 9004 FORMAT (' UTTRW Error ', i10)
 9005 FORMAT (' NBB Error ', i10)
 9006 FORMAT (i2, 1x, i2, 1x, i2)
 9007 FORMAT (2i2.2)
 9008 FORMAT (6(1x, f6.2, 1x, f7.4))
 9009 FORMAT (' DATE File Open Error')
 9010 FORMAT (' TIME File Open Error')
 9011 FORMAT (' GETPRIV Error ', i10)
c
c...Initialization.  We Own UTT And Use TIM
c
  100 err = DEV_UTTOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9001) err
        GO TO 200
      ENDIF
      err = DEV_TIMOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9002) err
        GO TO 200
      ENDIF
      err = DEV_GETPRIV()
      IF (err.eq.0) THEN
        tryit = 1
      ELSE
        WRITE (*,9011) err
        tryit = 0
      ENDIF
      DO i=1,6
        tempval(i) = 0.0
        timeval(i) = 0.0
      ENDDO
      DO j=1,NKEEP
        timekeep(j) = 0.0
        DO i=1,6
          tempkeep(i,j) = 0.0
        ENDDO
      ENDDO
      doinit = 1
c
c...Cute Stuff For WakeUp In Debugging Mode
c
      CALL idate(i,j,k)
      WRITE (mmdd,9007) i,j
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name='DUA0:[MONET.XPMM]TEMP.'//mmdd,
     *      status='old',
     *      unit=1
     *     )
      j = 0
      k = 0
  102 READ (1,9008,err=102,end=104) (tempval(i),timeval(i),i=1,6)
      j = j+1
      k = k+1
      xtime(j) = (timeval(1)+timeval(2)+timeval(3)+timeval(4)
     *           +timeval(5)+timeval(6))/6.0
      DO i=1,6
        xtemp(i,j) = tempval(i)
      ENDDO
      IF (j.ge.NKEEP) THEN
        j = 0
      ENDIF
      GO TO 102
  104 CLOSE (1)
      IF (k.lt.NKEEP) THEN
        DO k=1,j
          l = NKEEP+k-j
          timekeep(l) = xtime(k)
          DO i=1,6
            tempkeep(i,l) = xtemp(i,k)
          ENDDO
        ENDDO
      ELSE
        DO l=1,NKEEP
          k = l+j-NKEEP
          IF (k.le.0) THEN
            k = k + NKEEP
          ENDIF
          timekeep(l) = xtime(k)
          DO i=1,6
            tempkeep(i,l) = xtemp(i,k)
          ENDDO
        ENDDO
      ENDIF
c
c...Loop
c
c	Start By Waiting A While
c
  110 err = DEV_SLEEP(TAU1)
      IF (err.ne.0) THEN
        WRITE (*,9003) err
        GO TO 200
      ENDIF
c
c...Now Read All Thermometers
c
      DO who=1,6
        nbb = 20
        err = DEV_UTTRW(nbb,bb)
        IF (err.ne.0) THEN
          WRITE (*,9004) err
          GO TO 200
        ENDIF
        IF (nbb.ne.12) THEN
          WRITE (*,9005) nbb
          GO TO 200
        ENDIF
        i = bb(7)
        IF (IAND(8,i).ne.0) THEN
          sign = 1.0
        ELSE
          sign = -1.0
        ENDIF
        i = IAND(i,3)
        j = bb(8)
        k = bb(9)
        temp = sign*(10.0*i + IAND(j,15) + 0.1*IAND(k,15))
        i = bb(10)
        chan = 1+IAND(7,ISHFT(i,-1))
        tempval(chan) = MAX(-9.9,MIN(99.9,temp))
        CALL time(tb)
        READ (tb,9006,err=200) i,j,k
        timeval(chan) = i + (j/60.0) + (k/3600.0)
        err = DEV_SLEEP(TAU2)
        IF (err.ne.0) THEN
          WRITE (*,9003)
          GO TO 200
        ENDIF
      ENDDO
c
c...Update TEMP.MMDD And TEMP.LAST Files
c
      CALL idate(i,j,k)
      WRITE (mmdd,9007) i,j
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=210,
     *      form='formatted',
     *      name='DUA0:[MONET.XPMM]TEMP.'//mmdd,
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9008) (tempval(i),timeval(i),i=1,6)
      CLOSE (1)
  120 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=220,
     *      form='formatted',
     *      name='DUA0:[MONET.XPMM]TEMP.LAST',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9008) (tempval(i),timeval(i),i=1,6)
      CLOSE (1)
  130 CONTINUE
c
c...Update Our Stack
c
      DO j=1,NKEEP-1
        timekeep(j) = timekeep(j+1)
        DO i=1,6
          tempkeep(i,j) = tempkeep(i,j+1)
        ENDDO
      ENDDO
      timekeep(NKEEP) = (timeval(1)+timeval(2)+timeval(3)+timeval(4)
     *                  +timeval(5)+timeval(6))/6.0
      DO i=1,6
        tempkeep(i,NKEEP) = tempval(i)
      ENDDO
      do i=1,6
        faren(i) = tempval(i)*1.8 + 32.0
      enddo
      write (*,9999) (faren(i),i=1,6)
 9999 format (6f10.2)
c
c...Display If We Can Open PY
c
      IF (tryit.ne.0) THEN
        err = DEV_PYOPEN()
        IF (err.eq.0) THEN
          IF (doinit.ne.0) THEN
            CALL py_open(0,0,0,0)
            doinit = 0
          ENDIF
          CALL daemon_plot(NKEEP,timekeep,tempkeep)
          CALL dev_pyclose
        ELSE
          doinit = 1
        ENDIF
      ENDIF
c
c...All Done.   Cycle Until The Cows Come Home
c
      GO TO 110
c
c...Common Exit
c
  200 CALL dev_uttclose
      CALL dev_timclose
      CALL dev_givepriv
      CALL EXIT
  210 WRITE (*,9009)
      GO TO 120
  220 WRITE (*,9010)
      GO TO 130
      END
