c
c...These PARAMETER Statements Refer To Physical Q-Bus Addresses
c
      IMPLICIT
     *               NONE
      PARAMETER
     *               pkc_addr = '17734'o,
     *               pwc_addr = '04160'o,
     *               pyc_addr = '11420'o,
     *               pkm_addr = '01000000'o,
     *               pym_addr = '12000000'o
      PARAMETER
     *               dec_cbase = '20000000'x,
     *               dec_mbase = '30000000'x,
     *               pkc_base = (pkc_addr - ((pkc_addr/512)*512))/2 + 1,
     *               pwc_base = (pwc_addr - ((pwc_addr/512)*512))/2 + 1,
     *               pyc_base = (pyc_addr - ((pyc_addr/512)*512))/2 + 1
c
c...CCD0 Definitions -- DR11W Port
c
      INTEGER*4
     *               ccd_chan, ccd_efn
      INTEGER*2
     *               ccd_iosb(4)
c
c...IXA0 Definitions -- First IEEE-488 Bus
c
      PARAMETER
     *               me         = '000'o,
     *               LASER_ADD  = '003'o,
     *               ENC40_ADD  = '004'o,
     *               ENC61_ADD  = '004'o,
     *               UT_ADD     = '005'o,
     *               COUNT_ADD  = '006'o,
     *               LSTPRI_ADD = '007'o,
     *               LSTSEC_ADD = '010'o,
     *               AUXCNT_ADD = '011'o,
     *               him        = '017'o,
     *               K195_ADD   = '020'o,
     *               K705_ADD   = '021'o,
     *               MLAx       = '040'o,
     *               MTAx       = '100'o,
     *               UNL        = '077'o,
     *               UNT        = '177'o
      PARAMETER
     *               CinC    = '067'o,
     *               notCinC = '043'o,
     *               IO$_SERVICE     = '00000001'x,
     *               IO$_SER_POLL    = '00000002'x,
     *               IO$_COMMAND     = '00000007'x,
     *               IO$_GO_TO_CACS  = '00000008'x,
     *               IO$_GO_TO_CSBS  = '00000009'x,
     *               IO$_AUXILIARY   = '0000000A'x,
     *               IO$_SETEVENT    = '0000000D'x,
     *               IO$_REC_EVENT   = '0000000E'x,
     *               IO$_PASSCONTROL = '0000000F'x,
     *               IO$_COMMANDS    = '00000012'x,
     *               IO$M_TIMOUT     = '00004000'x
      INTEGER*4
     *               ie_efn, ie_chan, ie_whoami, ie_doservice,
     *               ie_reqarg, ie_clkmode, ie_hwest
      INTEGER*2
     *               ie_iosb(4)
      CHARACTER*4
     *               ie_dayno
      REAL*4
     *               ie_deltat
c
c...MT Controls MagTape I/O
c
      CHARACTER*10
     *               mt_username
      CHARACTER*4
     *               mt_name
      INTEGER*4
     *               mt_chan, mt_efn, mt_ret, mt_bswap, mt_fileno
      INTEGER*2
     *               mt_iosb(4)
      BYTE
     *               mt_buf(65536)
c
c...PKA0 Definitions -- Peritek VRA-Q
c
      INTEGER*4
     *               pkm_in(2), pkm_out(2), pk_efn,
     *               pkc_in(2), pkc_out(2), pk_chan
      INTEGER*2
     *               pk_iosb(4), pk_reg0, pk_reg1, pkc_page(256)
      BYTE
     *               pk_all(2048), pk_v1(1024), pk_v2(1024),
     *               pk_p1(64,16), pk_p2(64,16)
      EQUIVALENCE
     *               (pk_all(   1),pk_v1(1),pk_p1(1,1)),
     *               (pk_all(1025),pk_v2(1),pk_p2(1,1)),
     *               (pkc_page(pkc_base+0), pk_reg0),
     *               (pkc_page(pkc_base+1), pk_reg1)
c
c...PWA0 Definitions -- First DRV11-J Board
c
c	Due To AUTOCONFIGURE Problems, The Following Are The Assignments
c
c	0	764160
c	1	764140
c	2	764220
c	3	764260
c
c	NOTES:
c
c	1)	The IEEE-488 Bus Is At 764120
c	2)	These All Fit In A Single 512 Byte Mapping Block
c
      INTEGER*4
     *               pw_efn, pw_chan, pwc_in(2), pwc_out(2), pw_mode
      INTEGER*2
     *               pwc_page(256), pw_iosb(4),
     *               pw_acsr, pw_areg, pw_bcsr, pw_breg,
     *               pw_ccsr, pw_creg, pw_dcsr, pw_dreg,
     *               pw_ecsr, pw_ereg, pw_fcsr, pw_freg,
     *               pw_gcsr, pw_greg, pw_hcsr, pw_hreg,
     *               pw_icsr, pw_ireg, pw_jcsr, pw_jreg,
     *               pw_kcsr, pw_kreg, pw_lcsr, pw_lreg,
     *               pw_mcsr, pw_mreg, pw_ncsr, pw_nreg,
     *               pw_ocsr, pw_oreg, pw_pcsr, pw_preg
      EQUIVALENCE
     *               (pwc_page(pwc_base+ 0), pw_acsr),
     *               (pwc_page(pwc_base+ 1), pw_areg),
     *               (pwc_page(pwc_base+ 2), pw_bcsr),
     *               (pwc_page(pwc_base+ 3), pw_breg),
     *               (pwc_page(pwc_base+ 4), pw_ccsr),
     *               (pwc_page(pwc_base+ 5), pw_creg),
     *               (pwc_page(pwc_base+ 6), pw_dcsr),
     *               (pwc_page(pwc_base+ 7), pw_dreg)
      EQUIVALENCE
     *               (pwc_page(pwc_base- 8), pw_ecsr),
     *               (pwc_page(pwc_base- 7), pw_ereg),
     *               (pwc_page(pwc_base- 6), pw_fcsr),
     *               (pwc_page(pwc_base- 5), pw_freg),
     *               (pwc_page(pwc_base- 4), pw_gcsr),
     *               (pwc_page(pwc_base- 3), pw_greg),
     *               (pwc_page(pwc_base- 2), pw_hcsr),
     *               (pwc_page(pwc_base- 1), pw_hreg)
      EQUIVALENCE
     *               (pwc_page(pwc_base+16), pw_icsr),
     *               (pwc_page(pwc_base+17), pw_ireg),
     *               (pwc_page(pwc_base+18), pw_jcsr),
     *               (pwc_page(pwc_base+19), pw_jreg),
     *               (pwc_page(pwc_base+20), pw_kcsr),
     *               (pwc_page(pwc_base+21), pw_kreg),
     *               (pwc_page(pwc_base+22), pw_lcsr),
     *               (pwc_page(pwc_base+23), pw_lreg)
      EQUIVALENCE
     *               (pwc_page(pwc_base+32), pw_mcsr),
     *               (pwc_page(pwc_base+33), pw_mreg),
     *               (pwc_page(pwc_base+34), pw_ncsr),
     *               (pwc_page(pwc_base+35), pw_nreg),
     *               (pwc_page(pwc_base+36), pw_ocsr),
     *               (pwc_page(pwc_base+37), pw_oreg),
     *               (pwc_page(pwc_base+38), pw_pcsr),
     *               (pwc_page(pwc_base+39), pw_preg)
c
c...PYA0 Definitions -- Data Translation DT2651
c
      INTEGER*4
     *               pym_in(2), pym_out(2), py_efn,  pyc_invert,
     *               pyc_in(2), pyc_out(2), py_chan, pyc_sync
      INTEGER*2
     *               pyc_page(256), py_iosb(4),
     *               pyc_incsr1,  pyc_incsr2, pyc_outcsr, pyc_cursor,
     *               pyc_index,   pyc_inlut,  pyc_redgrn, pyc_blue,
     *               pyc_buf(256)
      BYTE
     *               py_pict(512,512,2), py_pic0(512,512),
     *               py_pic1(512,512), py_vect(512*512*2),
     *               py_vec0(512*512), py_vec1(512*512)
      EQUIVALENCE
     *           (py_pict(1,1,1),py_pic0(1,1),py_vec0(1),py_vect(1)),
     *           (py_pict(1,1,2),py_pic1(1,1),py_vec1(1)),
     *               (pyc_page(pyc_base+0), pyc_incsr1),
     *               (pyc_page(pyc_base+1), pyc_incsr2),
     *               (pyc_page(pyc_base+2), pyc_outcsr),
     *               (pyc_page(pyc_base+3), pyc_cursor),
     *               (pyc_page(pyc_base+4), pyc_index),
     *               (pyc_page(pyc_base+5), pyc_inlut),
     *               (pyc_page(pyc_base+6), pyc_redgrn),
     *               (pyc_page(pyc_base+7), pyc_blue)
c
c...PZ Is Westphal's Peritek Board
c
      INTEGER*4
     *               pz_chan, pz_efn
      INTEGER*2
     *               pz_iosb(4)
c
c...Video Switch (VS) Definitions -- Is Really Just A Terminal
c
      INTEGER*4
     *               vs_chan, vs_efn
      INTEGER*2
     *               vs_iosb(4)
      REAL
     *               vs_dummy
c
c...TT Channel Definitions
c
      INTEGER*4
     *               tt_chan, tt_efn
      INTEGER*2
     *               tt_iosb(4), tt_buf(4)
c
c...UTT Channel Definitions
c
      INTEGER*4
     *                utt_chan, utt_efn
      INTEGER*2
     *                utt_iosb(4)
c
c...XTT Channel Definitions
c
      INTEGER*4
     *                xtt_chan, xtt_efn
      INTEGER*2
     *                xtt_iosb(4)
c
c...STT Channel Definitions
c
      INTEGER*4
     *                stt_chan, stt_efn
      INTEGER*2
     *                stt_iosb(4)
c
c...NAG New AutoGuider Compumotor Definitions
c
      INTEGER*4
     *                nag_chan, nag_efn
      INTEGER*2
     *                nag_iosb(4)
c
c...RTS 40-inch Focus Terminal That Is Controlled By The RTS Line
c
      INTEGER*4
     *                rts_chan, rts_efn, rts_char(3), rts_exit(3)
      INTEGER*2
     *                rts_iosb(4)
c
c...CAM Is The Compumotor 61-inch Camera
c
      INTEGER*4
     *                cam_chan, cam_efn
      INTEGER*2
     *                cam_iosb(4)
c
c...ENC Is New Encoder RS-232 Bustle Interface
c
      INTEGER*4
     *                enc_chan, enc_efn
      INTEGER*2
     *                enc_iosb(4)
c
c...Timer Stuff
c
c	SLP Is Property Of Timer Used By DEV_SLEEP()
c
      INTEGER*4
     *                tim_efn0, tim_idt0, tim_buf0(2), tim_kill0,
     *                tim_efn1, tim_idt1, tim_buf1(2), tim_kill1,
     *                slp_efn,  slp_idt,  slp_buf(2)
c
c...PJA0 Is The DT2762 A/D Converter For The PMM
c
      INTEGER*4
     *                pj_chan, pj_efn
      INTEGER*2
     *                pj_iosb(4)

c
c...COMMON Declarations
c
      COMMON
     *               py_pict, pyc_page, pk_all, pkc_page, pwc_page
      COMMON /devices/
     *  IE_EFN,  IE_CHAN,  IE_IOSB,          PK_EFN,  PK_CHAN,  PK_IOSB,
     *  PW_EFN,  PW_CHAN,  PW_IOSB,          PZ_EFN,  PZ_CHAN,  PZ_IOSB,
     *  PY_EFN,  PY_CHAN,  PY_IOSB,          VS_EFN,  VS_CHAN,  VS_IOSB,
     *  TT_EFN,  TT_CHAN,  TT_IOSB,          MT_EFN,  MT_CHAN,  MT_IOSB,
     * CAM_EFN, CAM_CHAN, CAM_IOSB,         ENC_EFN, ENC_CHAN, ENC_IOSB,
     * STT_EFN, STT_CHAN, STT_IOSB,         UTT_EFN, UTT_CHAN, UTT_IOSB,
     * XTT_EFN, XTT_CHAN, XTT_IOSB,         NAG_EFN, NAG_CHAN, NAG_IOSB,
     * CCD_EFN, CCD_CHAN, CCD_IOSB,         RTS_EFN, RTS_CHAN, RTS_IOSB,
     *  PJ_EFN,  PJ_CHAN,  PJ_IOSB,
     * SLP_EFN, SLP_IDT,     TIM_EFN0, TIM_IDT0,     TIM_EFN1, TIM_IDT1,
     * pkc_in, pkc_out, pkm_in, pkm_out, pwc_in, pwc_out, pw_mode,
     * pyc_in, pyc_out, pym_in, pym_out, pyc_sync, pyc_invert, pyc_buf,
     * mt_name, mt_username, mt_buf, mt_ret, mt_bswap, mt_fileno,
     * slp_buf, tim_buf0, tim_buf1, tim_kill0, tim_kill1, vs_dummy,
     * tt_buf, ie_whoami, ie_doservice, ie_reqarg, ie_hwest, ie_clkmode,
     * ie_dayno, ie_deltat, rts_char, rts_exit
c
