c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encopen
c
c...Open ENC Channel For Telescope Encoder Bustles
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      PARAMETER
     *           ndummy = 64
      CHARACTER*8
     *           encname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF,
     *           nencname, DEV_ENCREAD
      BYTE
     *           buf(NDUMMY)
c
  100 ret=SYS$TRNLOG(
     1               'ENC$DEV',
     2               nencname,
     3               encname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               encname(1:nencname),
     2               enc_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_encopen = 1
        RETURN
      ENDIF
      enc_efn = 45
      ret = SYS$SETEF(%VAL(enc_efn))
      enc_iosb(1) = SS$_NORMAL
      dev_encopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encclose
c
c...Return ENC Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(enc_chan)
     *                )
      enc_chan = 0
      enc_efn = 0
      dev_encclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, m
      INTEGER*2
     *              encbuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(enc_efn),
     2              %VAL(enc_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              enc_iosb,
     5             ,
     6             ,
     7              encbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_encread = -1
        RETURN
      ENDIF
      IF (encbuf(1).le.0) THEN
        dev_encread = 0
        RETURN
      ENDIF
c
c...Read The Message
c
      m = MIN(encbuf(1),n)
      ret = SYS$QIOW(
     1              %VAL(enc_efn),
     2              %VAL(enc_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED),
     4              enc_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        dev_encread = -2
        RETURN
      ENDIF
      buf(enc_iosb(2)+1) = 10
      dev_encread = enc_iosb(2) + 1
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encwrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(enc_efn),
     2              %VAL(enc_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              enc_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_encwrite = -1
        RETURN
      ENDIF
      dev_encwrite = n
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encrw(nout,out,nin,in,mode)
c
c...Read With Prompt And Terminatior Modification
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, rtmask(4), rtdesc(2)
      INTEGER
     *            nout, nin, mode
      BYTE
     *            out(*), in(*)
c
c...Read Terminator Descriptor Block
c
  100 rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      IF (mode.eq.0) THEN
        rtmask(1)='00000000'x
        rtmask(2)='84000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ELSEIF (mode.gt.0) THEN
        rtmask(1)='00000000'x
        rtmask(2)='80000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ELSE
        rtmask(1)='00000000'x
        rtmask(2)='04000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ENDIF
c
c...Here to Issue the QIO request
c
      nout = nout+1
      out(nout) = 10
      ret=SYS$QIOW(
     1             %VAL(enc_efn),
     2             %VAL(enc_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             enc_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(nin),
     9             %VAL(4),
     A             rtdesc,
     B             out,
     C             %VAL(nout)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        dev_encrw = -1
      ELSE
        nin = enc_iosb(2)
        dev_encrw = 0
      ENDIF
      nout = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encmeter(t1,t2,t3,d1,d2,d3,p1,p2,p3)
c
c...Get The Meter String From 8-inch
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, rtdesc(2), rtmask(4)
      CHARACTER*(*)
     *            t1, t2, t3, d1, d2, d3, p1, p2, p3
      BYTE
     *            buf(3), get(70)
c
c...Mark All Values As Failure
c
  100 p1(1:1) = '*'
      p2(1:1) = '*'
      p3(1:1) = '*'
      d1(1:1) = '*'
      d2(1:1) = '*'
      d3(1:1) = '*'
      p1(1:1) = '*'
      p2(1:1) = '*'
      p3(1:1) = '*'
c
c...Purge The TypeAhead Buffer
c
      ret = SYS$QIOW(
     1               %VAL(enc_efn),
     2               %VAL(enc_chan),
     3               %VAL(IO$_READVBLK+IO$M_PURGE+IO$M_TIMED),
     4               enc_iosb,
     5              ,
     6              ,
     7               get,
     8               %VAL(0),
     9               %VAL(1),
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        dev_encmeter = -1
        RETURN
      ENDIF
c
c...Prompt First Meter In String
c
      buf(1) = '#'
      buf(2) = '0'
      buf(3) = '0'
      ret = SYS$QIOW(
     1               %VAL(enc_efn),
     2               %VAL(enc_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_TIMED),
     4               enc_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(3),
     9               %VAL(3),
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        dev_encmeter = -2
        RETURN
      ENDIF
c
c...Read Known Number Of Digits With No Terminator
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret = SYS$QIOW(
     1               %VAL(enc_efn),
     2               %VAL(enc_chan),
     3               %VAL(IO$_READVBLK+IO$M_NOECHO+IO$M_TIMED),
     4               enc_iosb,
     5              ,
     6              ,
     7               get,
     8               %VAL(69),
     9               %VAL(3),
     A               rtdesc,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        dev_encmeter = -3
        RETURN
      ENDIF
c
c...Crack The Pressures
c
      p1(1:1) = '5'
      p1(2:2) = CHAR(ZEXT(get( 8)))
      p1(3:3) = CHAR(ZEXT(get( 9)))
      p1(4:4) = '.'
      p1(5:5) = CHAR(ZEXT(get(10)))
      p2(1:1) = '5'
      p2(2:2) = CHAR(ZEXT(get(11)))
      p2(3:3) = CHAR(ZEXT(get(12)))
      p2(4:4) = '.'
      p2(5:5) = CHAR(ZEXT(get(13)))
      p3(1:1) = '5'
      p3(2:2) = CHAR(ZEXT(get(19)))
      p3(3:3) = CHAR(ZEXT(get(20)))
      p3(4:4) = '.'
      p3(5:5) = CHAR(ZEXT(get(21)))
c
c...Crack The Dew Points
c
      IF (IAND(ZEXT(get(30)),8).eq.0) THEN
        d1(1:1) = '-'
      ELSE
        d1(1:1) = '+'
      ENDIF
      d1(2:2) = CHAR(ZEXT(get(22)))
      d1(3:3) = CHAR(ZEXT(get(23)))
      d1(4:4) = '.'
      d1(5:5) = CHAR(ZEXT(get(24)))
      IF (IAND(ZEXT(get(30)),4).eq.0) THEN
        d2(1:1) = '-'
      ELSE
        d2(1:1) = '+'
      ENDIF
      d2(2:2) = CHAR(ZEXT(get(31)))
      d2(3:3) = CHAR(ZEXT(get(32)))
      d2(4:4) = '.'
      d2(5:5) = CHAR(ZEXT(get(33)))
c
c...Crack The Temperatures
c
      IF (IAND(ZEXT(get(30)),2).eq.0) THEN
        t1(1:1) = '-'
      ELSE
        t1(1:1) = '+'
      ENDIF
      t1(2:2) = CHAR(ZEXT(get(34)))
      t1(3:3) = CHAR(ZEXT(get(35)))
      t1(4:4) = '.'
      t1(5:5) = CHAR(ZEXT(get(41)))
      t1(6:6) = CHAR(ZEXT(get(42)))
      IF (IAND(ZEXT(get(30)),1).eq.0) THEN
        t2(1:1) = '-'
      ELSE
        t2(1:1) = '+'
      ENDIF
      t2(2:2) = CHAR(ZEXT(get(43)))
      t2(3:3) = CHAR(ZEXT(get(44)))
      t2(4:4) = '.'
      t2(5:5) = CHAR(ZEXT(get(45)))
      t2(6:6) = CHAR(ZEXT(get(46)))
      IF (IAND(ZEXT(get(52)),8).eq.0) THEN
        t3(1:1) = '-'
      ELSE
        t3(1:1) = '+'
      ENDIF
      t3(2:2) = CHAR(ZEXT(get(53)))
      t3(3:3) = CHAR(ZEXT(get(54)))
      t3(4:4) = '.'
      t3(5:5) = CHAR(ZEXT(get(55)))
      t3(6:6) = CHAR(ZEXT(get(56)))
      dev_encmeter = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_encbar(buf, n)
c
c...Read BarCode String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, i, j, m, n
      INTEGER*2
     *              encbuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(enc_efn),
     2              %VAL(enc_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              enc_iosb,
     5             ,
     6             ,
     7              encbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_encbar = -1
        RETURN
      ENDIF
      IF (encbuf(1).le.0) THEN
        dev_encbar = 0
        RETURN
      ENDIF
c
c...Read The Message.  Barcode reader inserts CR/NL
c
      ret = SYS$QIOW(
     1              %VAL(enc_efn),
     2              %VAL(enc_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED),
     4              enc_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(enc_iosb(1).ne.SS$_NORMAL)) THEN
        dev_encbar = -2
        RETURN
      ENDIF
c
c...Make True ASCII And Strip Out CR/NL, etc.
c
      m = 0
      DO i=1,enc_iosb(2)
        j = buf(i)
        j = IAND(j,127)
        IF ((j.gt.32).and.(j.lt.127)) THEN
          m = m+1
          buf(m) = j
        ENDIF
      ENDDO
      dev_encbar = m
      RETURN
      END
